/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.AbstractWaitWithProgressJob;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class NgrokDebugProvider
extends CloudFoundryDebugProvider {
    public static final String JAVA_OPTS = "JAVA_OPTS";

    public static String getFileContent(final CloudFoundryApplicationModule appModule, final CloudFoundryServer cloudServer, final String outputFilePath, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000);
        String content = null;
        CoreException error = null;
        try {
            content = (String)new AbstractWaitWithProgressJob<String>(100, 3000L, true){

                @Override
                protected String runInWait(IProgressMonitor monitor) throws CoreException {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    CloudApplication app = null;
                    try {
                        app = cloudServer.getBehaviour().getCloudApplication(appModule.getDeployedApplicationName(), (IProgressMonitor)subMonitor.newChild(50));
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError(e);
                    }
                    if (app != null && app.getState() == CloudApplication.AppState.STARTED) {
                        boolean isDir = false;
                        return cloudServer.getBehaviour().getFile(appModule.getApplication(), 0, outputFilePath, isDir, (IProgressMonitor)subMonitor.newChild(50));
                    }
                    return null;
                }

                @Override
                protected boolean isValid(String result) {
                    return true;
                }
            }.run((IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            error = e;
        }
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (content == null) {
            String message = "Failed to connect debugger to Cloud application - Timed out fetching ngrok output file for: " + appModule.getDeployedApplicationName() + ". Please verify that the ngrok output file exists in the Cloud or that the application is running correctly.";
            if (error != null) {
                throw CloudErrorUtil.asCoreException(message, error, false);
            }
            throw CloudErrorUtil.toCoreException(message);
        }
        return content;
    }

    @Override
    public boolean isDebugSupported(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject(appModule);
        return javaProject != null && javaProject.exists() && this.containsDebugFiles(javaProject);
    }

    public static boolean containsDebugOption(EnvironmentVariable var) {
        return var != null && var.getValue() != null && JAVA_OPTS.equals(var.getVariable()) && (var.getValue().contains("-Xdebug") || var.getValue().contains("-Xrunjdwp"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean containsDebugFiles(IJavaProject project) {
        try {
            IClasspathEntry[] entries = project.getResolvedClasspath(true);
            if (entries == null) return false;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry != null && entry.getEntryKind() == 3) {
                    IPath projectPath = project.getPath();
                    IPath relativePath = entry.getPath().makeRelativeTo(projectPath);
                    IFolder folder = project.getProject().getFolder(relativePath);
                    if (NgrokDebugProvider.getFile((IResource)folder, ".profile.d", "ngrok.sh") != null) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
        catch (CoreException ce) {
            CloudFoundryPlugin.logError(ce);
        }
        return false;
    }

    public static IFile getFile(IResource resource, String containingFolderName, String fileName) throws CoreException {
        IContainer container;
        IResource[] children;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource instanceof IFile && resource.getName().equals(fileName) && resource.getParent() != null && resource.getParent().getName().equals(containingFolderName)) {
            return (IFile)resource;
        }
        if (resource instanceof IContainer && (children = (container = (IContainer)resource).members()) != null) {
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                IFile file = NgrokDebugProvider.getFile(child, containingFolderName, fileName);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getLaunchConfigurationType(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        return "org.eclipse.cft.debug.launchconfig.ngrok";
    }
}

