/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleTransitivityHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ToggleTransitivityHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        ToggleTransitivityHandler.setTraceViewTransitive(!oldValue);
        return null;
    }

    public static boolean isTraceViewTransitive() {
        Preferences transitivity = ToggleTransitivityHandler.getPreference();
        return transitivity.get("option", "direct").equals("transitive");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.toggleTransitivity");
        return preferences.node("transitivity");
    }

    public static void setTraceViewTransitive(boolean value) {
        Preferences transitivity = ToggleTransitivityHandler.getPreference();
        transitivity.put("option", value ? "transitive" : "direct");
        try {
            transitivity.flush();
        }
        catch (BackingStoreException e) {
            LOG.warn("Could not save transitivity preferences!", (Throwable)e);
        }
    }
}

