/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayInternalLinksHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DisplayInternalLinksHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DisplayInternalLinksHandler.showInternalLinks(!DisplayInternalLinksHandler.areInternalLinksShown());
        return null;
    }

    public static boolean areInternalLinksShown() {
        Preferences internalLinks = DisplayInternalLinksHandler.getPreference();
        return internalLinks.get("option", "turnedOff").equals("shown");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.toggleInternalLinks");
        return preferences.node("internalLinks");
    }

    public static void showInternalLinks(boolean value) {
        Preferences internalLinks = DisplayInternalLinksHandler.getPreference();
        internalLinks.put("option", value ? "shown" : "turnedOff");
        try {
            internalLinks.flush();
        }
        catch (BackingStoreException e) {
            LOG.warn("Could not save internal links preferences!", (Throwable)e);
        }
    }
}

