/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.CompositeBuildModelRequest;
import com.gradleware.tooling.toolingclient.CompositeBuildRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.GradleBuildIdentifier;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingclient.LongRunningOperationPromise;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.TestConfig;
import com.gradleware.tooling.toolingclient.TestLaunchRequest;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultCompositeBuildModelRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultModelRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultTestLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableCompositeBuildModelRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableCompositeBuildRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableModelRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableSingleBuildRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableTestLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.deduplication.DeduplicatingGradleConnection;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.internal.Factory;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.connection.GradleConnection;
import org.gradle.tooling.connection.GradleConnectionBuilder;
import org.gradle.tooling.connection.ModelResult;
import org.gradle.tooling.connection.ModelResults;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.connection.GradleConnectionBuilderInternal;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultToolingClient
extends ToolingClient
implements ExecutableToolingClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultToolingClient.class);
    private final Factory<GradleConnector> connectorFactory;
    private final ToolingClient.ConnectionStrategy connectionStrategy;
    private final Map<Integer, ProjectConnection> connections;
    private final Map<Integer, GradleConnection> compositeConnections;

    public DefaultToolingClient() {
        this(DefaultGradleConnectorFactory.INSTANCE);
    }

    public DefaultToolingClient(Factory<GradleConnector> connectorFactory) {
        this(connectorFactory, ToolingClient.ConnectionStrategy.PER_REQUEST);
    }

    public DefaultToolingClient(Factory<GradleConnector> connectorFactory, ToolingClient.ConnectionStrategy connectionStrategy) {
        this.connectorFactory = connectorFactory;
        this.connectionStrategy = connectionStrategy;
        this.connections = Maps.newHashMap();
        this.compositeConnections = Maps.newHashMap();
    }

    @Override
    public <T> ModelRequest<T> newModelRequest(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new DefaultModelRequest<T>(this, modelType);
    }

    @Override
    public <T> BuildActionRequest<T> newBuildActionRequest(BuildAction<T> buildAction) {
        Preconditions.checkNotNull(buildAction);
        return new DefaultBuildActionRequest<T>(this, buildAction);
    }

    @Override
    public BuildLaunchRequest newBuildLaunchRequest(LaunchableConfig launchables) {
        Preconditions.checkNotNull((Object)launchables);
        return new DefaultBuildLaunchRequest(this, launchables);
    }

    @Override
    public TestLaunchRequest newTestLaunchRequest(TestConfig tests) {
        Preconditions.checkNotNull((Object)tests);
        return new DefaultTestLaunchRequest(this, tests);
    }

    @Override
    public <T> CompositeBuildModelRequest<T> newCompositeModelRequest(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new DefaultCompositeBuildModelRequest<T>(this, modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeAndWait(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        try {
            Object object = operation.get();
            return (T)object;
        }
        finally {
            this.closeConnectionIfNecessary(connection);
        }
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        return this.closeConnectionIfNecessary(LongRunningOperationPromise.forModelBuilder(operation), connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeAndWait(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        try {
            Object object = operation.run();
            return (T)object;
        }
        finally {
            this.closeConnectionIfNecessary(connection);
        }
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        return this.closeConnectionIfNecessary(LongRunningOperationPromise.forBuildActionExecuter(operation), connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void executeAndWait(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        try {
            operation.run();
        }
        finally {
            this.closeConnectionIfNecessary(connection);
        }
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        return this.closeConnectionIfNecessary(LongRunningOperationPromise.forBuildLauncher(operation), connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void executeAndWait(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        try {
            operation.run();
        }
        finally {
            this.closeConnectionIfNecessary(connection);
        }
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        return this.closeConnectionIfNecessary(LongRunningOperationPromise.forTestLauncher(operation), connection);
    }

    @Override
    public <T> LongRunningOperationPromise<ModelResults<T>> execute(InspectableCompositeBuildModelRequest<T> modelRequest) {
        GradleConnection connection = this.getCompositeConnection(modelRequest);
        ModelBuilder<ModelResults<T>> modelBuilder = this.mapToModelBuilder(modelRequest, connection);
        return this.closeConnectionIfNecessary(LongRunningOperationPromise.forModelBuilder(modelBuilder), connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ModelResults<T> executeAndWait(InspectableCompositeBuildModelRequest<T> modelRequest) {
        GradleConnection connection = this.getCompositeConnection(modelRequest);
        ModelBuilder<ModelResults<T>> modelBuilder = this.mapToModelBuilder(modelRequest, connection);
        try {
            ModelResults modelResults;
            ModelResults modelResults2 = modelResults = (ModelResults)modelBuilder.get();
            return modelResults2;
        }
        finally {
            this.closeConnectionIfNecessary(connection);
        }
    }

    private ProjectConnection getProjectConnection(InspectableSingleBuildRequest<?> request) {
        return this.getOrCreateProjectConnection(request);
    }

    private GradleConnection getCompositeConnection(InspectableCompositeBuildRequest<?> request) {
        return this.getOrCreateCompositeConnection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConnection getOrCreateProjectConnection(InspectableSingleBuildRequest<?> simpleRequest) {
        ProjectConnection connection;
        Preconditions.checkNotNull(simpleRequest);
        if (this.connectionStrategy == ToolingClient.ConnectionStrategy.PER_REQUEST) {
            return this.openConnection(simpleRequest);
        }
        int connectionKey = this.calculateConnectionKey(simpleRequest);
        Map<Integer, ProjectConnection> map = this.connections;
        synchronized (map) {
            connection = this.connections.get(connectionKey);
            if (connection == null) {
                connection = this.openConnection(simpleRequest);
                this.connections.put(connectionKey, connection);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleConnection getOrCreateCompositeConnection(InspectableCompositeBuildRequest<?> compositeRequest) {
        GradleConnection connection;
        Preconditions.checkNotNull(compositeRequest);
        if (this.connectionStrategy == ToolingClient.ConnectionStrategy.PER_REQUEST) {
            return this.openCompositeConnection(compositeRequest);
        }
        int connectionKey = this.calculateCompositeConnectionKey(compositeRequest);
        Map<Integer, GradleConnection> map = this.compositeConnections;
        synchronized (map) {
            connection = this.compositeConnections.get(connectionKey);
            if (connection == null) {
                connection = this.openCompositeConnection(compositeRequest);
                this.compositeConnections.put(connectionKey, connection);
            }
        }
        return connection;
    }

    private int calculateConnectionKey(InspectableSingleBuildRequest<?> modelRequest) {
        return Objects.hashCode((Object[])new Object[]{modelRequest.getProjectDir(), modelRequest.getGradleUserHomeDir(), modelRequest.getGradleDistribution()});
    }

    private int calculateCompositeConnectionKey(InspectableCompositeBuildRequest<?> compositeRequest) {
        ArrayList connectionProperties = Lists.newArrayList();
        for (GradleBuildIdentifier identifier : compositeRequest.getParticipants()) {
            connectionProperties.add(identifier.getProjectDir());
            connectionProperties.add(identifier.getGradleDistribution());
        }
        connectionProperties.add(compositeRequest.getGradleUserHomeDir());
        return ((Object)connectionProperties).hashCode();
    }

    private ProjectConnection openConnection(InspectableSingleBuildRequest<?> modelRequest) {
        GradleConnector connector = (GradleConnector)this.connectorFactory.create();
        connector.forProjectDirectory(modelRequest.getProjectDir());
        connector.useGradleUserHomeDir(modelRequest.getGradleUserHomeDir());
        modelRequest.getGradleDistribution().apply(connector);
        return connector.connect();
    }

    private GradleConnection openCompositeConnection(InspectableCompositeBuildRequest<?> compositeRequest) {
        GradleConnection actualConnection = this.createIntegratedCompositeIfPossible(compositeRequest);
        return new DeduplicatingGradleConnection(actualConnection);
    }

    private GradleConnection createIntegratedCompositeIfPossible(InspectableCompositeBuildRequest<?> compositeRequest) {
        GradleConnectionBuilder connectionBuilder = this.configureBasicCompositeConnection(compositeRequest);
        GradleConnection aggregateConnection = connectionBuilder.build();
        if (!(connectionBuilder instanceof GradleConnectionBuilderInternal)) {
            return aggregateConnection;
        }
        GradleVersion commonGradleVersion = this.getCommonGradleVersion(aggregateConnection, compositeRequest);
        if (commonGradleVersion == null || commonGradleVersion.compareTo(GradleVersion.version((String)"2.14-rc-1")) < 0) {
            return aggregateConnection;
        }
        ((GradleConnectionBuilderInternal)connectionBuilder).integratedComposite(true);
        ((GradleConnectionBuilderInternal)connectionBuilder).useGradleVersion(commonGradleVersion.getVersion());
        return connectionBuilder.build();
    }

    private GradleVersion getCommonGradleVersion(GradleConnection aggregateConnection, InspectableCompositeBuildRequest<?> compositeRequest) {
        ModelResults<BuildEnvironment> results = this.fetchBuildEnvironments(aggregateConnection, compositeRequest);
        String commonVersion = null;
        for (ModelResult result : results) {
            if (result.getFailure() != null) {
                return null;
            }
            BuildEnvironment buildEnvironment = (BuildEnvironment)result.getModel();
            String gradleVersion = buildEnvironment.getGradle().getGradleVersion();
            if (commonVersion != null && !commonVersion.equals(gradleVersion)) {
                return null;
            }
            commonVersion = gradleVersion;
        }
        return GradleVersion.version(commonVersion);
    }

    private GradleConnectionBuilder configureBasicCompositeConnection(InspectableCompositeBuildRequest<?> compositeRequest) {
        if (compositeRequest.getParticipants().length == 0) {
            throw new IllegalArgumentException("There must be at least one participant in a composite build");
        }
        GradleConnectionBuilder connectionBuilder = GradleConnector.newGradleConnection();
        connectionBuilder.useGradleUserHomeDir(compositeRequest.getGradleUserHomeDir());
        for (GradleBuildIdentifier identifier : compositeRequest.getParticipants()) {
            GradleConnectionBuilder.ParticipantBuilder participantBuilder = connectionBuilder.addParticipant(identifier.getProjectDir());
            identifier.getGradleDistribution().apply(participantBuilder);
        }
        return connectionBuilder;
    }

    private ModelResults<BuildEnvironment> fetchBuildEnvironments(GradleConnection aggregateConnection, InspectableCompositeBuildRequest<?> compositeRequest) {
        ModelBuilder builder = aggregateConnection.models(BuildEnvironment.class);
        this.mapToLongRunningOperation(compositeRequest, builder);
        return (ModelResults)builder.get();
    }

    private <T> ModelBuilder<T> mapToModelBuilder(InspectableModelRequest<T> modelRequest, ProjectConnection connection) {
        ModelBuilder modelBuilder = connection.model(modelRequest.getModelType());
        modelBuilder.forTasks(modelRequest.getTasks());
        return this.mapToLongRunningOperation(modelRequest, modelBuilder);
    }

    private <T> ModelBuilder<ModelResults<T>> mapToModelBuilder(InspectableCompositeBuildModelRequest<T> modelRequest, GradleConnection connection) {
        ModelBuilder modelBuilder = connection.models(modelRequest.getModelType());
        return this.mapToLongRunningOperation(modelRequest, modelBuilder);
    }

    private <T> BuildActionExecuter<T> mapToBuildActionExecuter(InspectableBuildActionRequest<T> buildActionRequest, ProjectConnection connection) {
        BuildActionExecuter buildActionExecuter = connection.action(buildActionRequest.getBuildAction());
        return this.mapToLongRunningOperation(buildActionRequest, buildActionExecuter);
    }

    private BuildLauncher mapToBuildLauncher(InspectableBuildLaunchRequest buildLaunchRequest, ProjectConnection connection) {
        BuildLauncher buildLauncher = connection.newBuild();
        buildLaunchRequest.getLaunchables().apply(buildLauncher);
        return this.mapToLongRunningOperation(buildLaunchRequest, buildLauncher);
    }

    private TestLauncher mapToTestLauncher(InspectableTestLaunchRequest testLaunchRequest, ProjectConnection connection) {
        TestLauncher testLauncher = connection.newTestLauncher();
        testLaunchRequest.getTests().apply(testLauncher);
        return this.mapToLongRunningOperation(testLaunchRequest, testLauncher);
    }

    private <T extends LongRunningOperation> T mapToLongRunningOperation(InspectableRequest<?> request, T operation) {
        operation.setColorOutput(request.isColorOutput()).setStandardOutput(request.getStandardOutput()).setStandardError(request.getStandardError()).setJavaHome(request.getJavaHomeDir()).setJvmArguments(request.getJvmArguments()).withArguments(request.getArguments()).withCancellationToken(request.getCancellationToken());
        if (!(request instanceof CompositeBuildRequest)) {
            operation.setStandardInput(request.getStandardInput());
        }
        for (org.gradle.tooling.ProgressListener progressListener : request.getProgressListeners()) {
            operation.addProgressListener(progressListener);
        }
        for (org.gradle.tooling.ProgressListener progressListener : request.getTypedProgressListeners()) {
            operation.addProgressListener((ProgressListener)progressListener);
        }
        return operation;
    }

    @Override
    public void stop(ToolingClient.CleanUpStrategy strategy) {
        switch (strategy) {
            case FORCEFULLY: {
                throw new UnsupportedOperationException(String.format("Cleanup strategy %s is currently not supported.", new Object[]{ToolingClient.CleanUpStrategy.FORCEFULLY}));
            }
            case GRACEFULLY: {
                this.closeConnections();
                this.expireDaemons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        Map<Integer, ProjectConnection> map = this.connections;
        synchronized (map) {
            for (ProjectConnection projectConnection : this.connections.values()) {
                this.closeConnection(projectConnection);
            }
        }
        map = this.compositeConnections;
        synchronized (map) {
            for (GradleConnection gradleConnection : this.compositeConnections.values()) {
                this.closeConnection(gradleConnection);
            }
        }
    }

    private void closeConnection(ProjectConnection connection) {
        try {
            connection.close();
        }
        catch (Exception e) {
            LOG.warn("Problem closing the connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeConnection(GradleConnection connection) {
        try {
            connection.close();
        }
        catch (Exception e) {
            LOG.warn("Problem closing the composite connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> void closeConnectionIfNecessary(ProjectConnection connection) {
        if (this.connectionStrategy == ToolingClient.ConnectionStrategy.PER_REQUEST) {
            this.closeConnection(connection);
        }
    }

    private <T> void closeConnectionIfNecessary(GradleConnection connection) {
        if (this.connectionStrategy == ToolingClient.ConnectionStrategy.PER_REQUEST) {
            this.closeConnection(connection);
        }
    }

    private <T> LongRunningOperationPromise<T> closeConnectionIfNecessary(final LongRunningOperationPromise<T> delegate, final ProjectConnection connection) {
        return new LongRunningOperationPromise<T>(){

            @Override
            public LongRunningOperationPromise<T> onComplete(Consumer<? super T> completeHandler) {
                DefaultToolingClient.this.closeConnectionIfNecessary(connection);
                delegate.onComplete(completeHandler);
                return this;
            }

            @Override
            public LongRunningOperationPromise<T> onFailure(Consumer<? super GradleConnectionException> failureHandler) {
                DefaultToolingClient.this.closeConnectionIfNecessary(connection);
                delegate.onFailure(failureHandler);
                return this;
            }
        };
    }

    private <T> LongRunningOperationPromise<T> closeConnectionIfNecessary(final LongRunningOperationPromise<T> delegate, final GradleConnection connection) {
        return new LongRunningOperationPromise<T>(){

            @Override
            public LongRunningOperationPromise<T> onComplete(Consumer<? super T> completeHandler) {
                DefaultToolingClient.this.closeConnectionIfNecessary(connection);
                delegate.onComplete(completeHandler);
                return this;
            }

            @Override
            public LongRunningOperationPromise<T> onFailure(Consumer<? super GradleConnectionException> failureHandler) {
                DefaultToolingClient.this.closeConnectionIfNecessary(connection);
                delegate.onFailure(failureHandler);
                return this;
            }
        };
    }

    private void expireDaemons() {
        ConnectorServices.reset();
    }

    private static enum DefaultGradleConnectorFactory implements Factory<GradleConnector>
    {
        INSTANCE;


        public GradleConnector create() {
            return GradleConnector.newConnector();
        }
    }
}

