/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.group;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.group.DateGroupCalculator;

class MinuteGroupCalculator
extends DateGroupCalculator {
    public MinuteGroupCalculator(Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws BirtException {
        super(intervalStart, intervalRange, locale, timeZone);
    }

    @Override
    public Object calculate(Object value) {
        if (value == null) {
            return new Double(-1.0);
        }
        if (this.intervalStart == null) {
            return new Double(Math.floor(this.dateTimeUtil.diffMinute(this.defaultStart, (Date)value) / (long)this.getDateIntervalRange()));
        }
        if (this.dateTimeUtil.diffMinute((Date)this.intervalStart, (Date)value) < 0L) {
            return new Double(-1.0);
        }
        return new Double(Math.floor(this.dateTimeUtil.diffMinute((Date)this.intervalStart, (Date)value) / (long)this.getDateIntervalRange()));
    }
}

