/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;

public abstract class AbstractReportContentWriter
implements IReportContentWriter {
    protected static Logger logger = Logger.getLogger(IReportContentWriter.class.getName());

    @Override
    public long writeFullContent(IContent content) throws IOException, BirtException {
        long offset = this.getOffset();
        new ContentWriterVisitor().write(content, this);
        return offset;
    }

    private static class ContentWriterVisitor
    extends ContentVisitorAdapter {
        private ContentWriterVisitor() {
        }

        public void write(IContent content, IReportContentWriter writer) throws BirtException {
            this.visit(content, writer);
        }

        @Override
        public Object visitContent(IContent content, Object value) {
            IReportContentWriter writer = (IReportContentWriter)value;
            try {
                writer.writeContent(content);
                for (IContent child : content.getChildren()) {
                    this.visitContent(child, value);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write content failed");
            }
            return value;
        }

        @Override
        public Object visitPage(IPageContent page, Object value) {
            IReportContentWriter writer = (IReportContentWriter)value;
            try {
                writer.writeContent(page);
                for (IContent content : page.getHeader()) {
                    this.visitContent(content, value);
                }
                for (IContent content : page.getFooter()) {
                    this.visitContent(content, value);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write content failed");
            }
            return value;
        }
    }
}

