/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FormatSpecifierImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class JavaDateFormatSpecifierImpl
extends FormatSpecifierImpl
implements JavaDateFormatSpecifier {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;

    protected JavaDateFormatSpecifierImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return AttributePackage.Literals.JAVA_DATE_FORMAT_SPECIFIER;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPattern, (Object)this.pattern));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(')');
        return result.toString();
    }

    public static JavaDateFormatSpecifier create(String sJavaPattern) {
        JavaDateFormatSpecifier jdfs = AttributeFactory.eINSTANCE.createJavaDateFormatSpecifier();
        jdfs.setPattern(sJavaPattern);
        return jdfs;
    }

    @Override
    public String format(Calendar c, ULocale lcl) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getPattern(), lcl);
        if (c instanceof CDateTime && ((CDateTime)c).isFullDateTime()) {
            sdf.setTimeZone(c.getTimeZone());
        }
        return sdf.format(c.getTime());
    }

    @Override
    public String format(Calendar c, Locale lcl) {
        return this.format(c, ULocale.forLocale((Locale)lcl));
    }

    @Override
    public JavaDateFormatSpecifier copyInstance() {
        JavaDateFormatSpecifierImpl dest = new JavaDateFormatSpecifierImpl();
        dest.set(this);
        return dest;
    }

    protected void set(JavaDateFormatSpecifier src) {
        super.set(src);
        this.pattern = src.getPattern();
    }
}

