/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.util;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class HTMLParser {
    FileReader reader;
    LineNumberReader in;
    String token;
    ArrayList attribs = new ArrayList();
    int pushC = -1;
    private boolean ignoreWhitespace = true;
    public static final int EOF = -1;
    public static final int TEXT = 1;
    public static final int DOCTYPE = 2;
    public static final int ELEMENT = 3;
    public static final int COMMENT = 4;
    public static final int SPECIAL_ELEMENT = 5;
    public static final int START_ELEMENT = 0;
    public static final int END_ELEMENT = 1;
    public static final int SINGLE_ELEMENT = 2;
    static String[] formatTags = new String[]{"i", "b", "strong", "em", "code", "span", "a"};

    public void open(String fileName) throws FileNotFoundException {
        this.reader = new FileReader(fileName);
        this.in = new LineNumberReader(this.reader);
    }

    public void close() {
        try {
            this.in.close();
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getTokenText() {
        return this.token;
    }

    public int getElementType() {
        if (this.token.startsWith("/")) {
            return 1;
        }
        if (this.token.endsWith("/")) {
            return 2;
        }
        return 0;
    }

    public String getElement() {
        if (this.token.startsWith("/")) {
            return this.token.substring(1);
        }
        if (this.token.endsWith("/")) {
            return this.token.substring(0, this.token.length() - 1);
        }
        return this.token;
    }

    public ArrayList getAttribs() {
        return this.attribs;
    }

    public String getAttrib(String name) {
        int i = 0;
        while (i < this.attribs.size()) {
            AttribPair a = (AttribPair)this.attribs.get(i);
            if (a.attrib.equalsIgnoreCase(name)) {
                return a.value;
            }
            ++i;
        }
        return null;
    }

    private int getC() {
        if (this.pushC != -1) {
            int c = this.pushC;
            this.pushC = -1;
            return c;
        }
        try {
            return this.in.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private void pushC(int c) {
        this.pushC = c;
    }

    public int getToken() {
        do {
            int c = this.getC();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 60: {
                    return this.getElement(c);
                }
            }
            this.parseText(c);
        } while (this.ignoreWhitespace && this.token.trim().length() <= 0);
        return 1;
    }

    private int parseText(int c) {
        StringBuilder text = new StringBuilder();
        while (c != -1) {
            if (c == 60) {
                this.pushC(c);
                break;
            }
            if (c == 8220 || c == 8221) {
                text.append("&quot;");
            } else {
                text.append((char)c);
            }
            c = this.getC();
        }
        this.token = text.toString();
        return 1;
    }

    private int skipSpace(int c) {
        while (c != -1 && Character.isWhitespace((char)c)) {
            c = this.getC();
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private int getElement(int c) {
        c = this.getC();
        if (c == -1) {
            return -1;
        }
        if (c == 33) {
            return this.getSpecialElement();
        }
        this.attribs.clear();
        c = this.skipSpace(c);
        if (c == -1) {
            return -1;
        }
        tag = new StringBuilder();
        if (c != 47) ** GOTO lbl28
        tag.append((char)c);
        c = this.skipSpace(this.getC());
        while (c != -1 && c != 62 && !Character.isWhitespace((char)c)) {
            tag.append((char)c);
            c = this.getC();
        }
        this.token = tag.toString();
        while (c != 62 && c != -1) {
            c = this.getC();
        }
        return 3;
lbl-1000:
        // 1 sources

        {
            tag.append((char)c);
            c = this.getC();
lbl28:
            // 2 sources

            ** while (c != -1 && c != 62 && c != 47 && !Character.isWhitespace((char)((char)c)))
        }
lbl29:
        // 1 sources

        if (c == -1) {
            this.token = tag.toString();
            return 3;
        }
        while ((c = this.skipSpace(c)) != -1 && c != 62 && c != 47) {
            c = this.getAttrib(c);
        }
        if (c == 47) {
            tag.append((char)c);
            while ((c = this.getC()) != -1 && c != 62) {
            }
        }
        this.token = tag.toString();
        return 3;
    }

    private int getAttrib(int c) {
        AttribPair a = new AttribPair();
        StringBuilder s = new StringBuilder();
        while (c != -1 && c != 61 && !Character.isWhitespace((char)c)) {
            s.append((char)c);
            c = this.getC();
        }
        a.attrib = s.toString();
        if ((c = this.skipSpace(c)) != 61) {
            this.attribs.add(a);
            return c;
        }
        s = new StringBuilder();
        c = this.skipSpace(this.getC());
        if (c == 39 || c == 34) {
            int quote = c;
            while ((c = this.getC()) != -1) {
                if (c == quote) {
                    c = this.getC();
                    break;
                }
                if (c == 92) {
                    c = this.getC();
                    if (c != -1) {
                        s.append('\\');
                        s.append((char)c);
                        continue;
                    }
                    break;
                }
                s.append((char)c);
            }
        } else {
            while ((c = this.getC()) != -1) {
                if (c == 62 || c == 47 || Character.isWhitespace((char)c)) {
                    c = this.getC();
                    break;
                }
                s.append((char)c);
            }
        }
        a.value = s.toString();
        this.attribs.add(a);
        return c;
    }

    private int getSpecialElement() {
        int c;
        StringBuilder text = new StringBuilder();
        text.append("<!");
        while ((c = this.getC()) != -1 && c != 62) {
            text.append((char)c);
        }
        text.append('>');
        this.token = text.toString();
        if (this.token.startsWith("<!--")) {
            return 4;
        }
        return 5;
    }

    public boolean isFormatTag() {
        return this.isFormatTag(this.getElement());
    }

    public boolean isFormatTag(String tag) {
        int i = 0;
        while (i < formatTags.length) {
            if (formatTags[i].equalsIgnoreCase(tag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getFullElement() {
        StringBuilder text = new StringBuilder();
        text.append('<');
        int elementType = this.getElementType();
        if (elementType == 1) {
            text.append('/');
        }
        text.append(this.getElement());
        int i = 0;
        while (i < this.attribs.size()) {
            text.append(' ');
            AttribPair a = (AttribPair)this.attribs.get(i);
            text.append(a.attrib);
            text.append("=\"");
            if (a.value != null) {
                text.append(a.value);
            }
            text.append("\"");
            ++i;
        }
        if (elementType == 2) {
            text.append('/');
        }
        text.append('>');
        return text.toString();
    }

    public int getLineNo() {
        return this.in.getLineNumber();
    }

    public void ignoreWhitespace(boolean b) {
        this.ignoreWhitespace = b;
    }

    static class AttribPair {
        String attrib;
        String value;

        AttribPair() {
        }
    }
}

