/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class FontStylePropertyDescriptorProvider
extends PropertyDescriptorProvider
implements IToggleDescriptorProvider {
    private String defaltValue = "";
    private String toggleValue = "";

    public FontStylePropertyDescriptorProvider(String property, String element) {
        super(property, element);
        if (property.equals("fontWeight")) {
            this.defaltValue = "normal";
            this.toggleValue = "bold";
        }
        if (property.equals("fontStyle")) {
            this.defaltValue = "normal";
            this.toggleValue = "italic";
        }
        if (property.equals("textUnderline")) {
            this.defaltValue = "none";
            this.toggleValue = "underline";
        }
        if (property.equals("textLineThrough")) {
            this.defaltValue = "none";
            this.toggleValue = "line-through";
        }
    }

    @Override
    public String getTooltipText() {
        if (this.toggleValue.equals("bold")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Bold");
        }
        if (this.toggleValue.equals("italic")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Italic");
        }
        if (this.toggleValue.equals("underline")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Underline");
        }
        if (this.toggleValue.equals("line-through")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Text_Line_Through");
        }
        if (this.toggleValue.equals("bold")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Bold");
        }
        if (this.toggleValue.equals("italic")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Italic");
        }
        if (this.toggleValue.equals("underline")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Underline");
        }
        if (this.toggleValue.equals("line-through")) {
            return Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Text_Line_Through");
        }
        return "";
    }

    @Override
    public String getImageName() {
        return this.getProperty();
    }

    public String getToogleValue() {
        return this.toggleValue;
    }

    @Override
    public void save(Object value) throws SemanticException {
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? this.toggleValue : this.defaltValue;
        }
        super.save(value);
    }
}

