/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.IDatasetWorkspaceClasspathFinder;
import org.eclipse.birt.report.viewer.utilities.IWorkspaceClasspathFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

@Deprecated
public class WorkspaceClassPathFinder
implements IWorkspaceClasspathFinder,
IDatasetWorkspaceClasspathFinder {
    public String getClassPath(String projects) {
        if (projects == null || projects.length() == 0) {
            return null;
        }
        StringBuilder wbuf = new StringBuilder();
        StringTokenizer token = new StringTokenizer(projects, PROPERTYSEPARATOR);
        boolean hasHeader = false;
        while (token.hasMoreTokens()) {
            String projectName = token.nextToken();
            List paths = this.getProjectPaths(projectName);
            int i = 0;
            while (i < paths.size()) {
                String url = (String)paths.get(i);
                if (url != null && url.length() != 0) {
                    if (i == 0 && !hasHeader) {
                        wbuf.append(url);
                        hasHeader = true;
                    } else {
                        wbuf.append(String.valueOf(PROPERTYSEPARATOR) + url);
                    }
                }
                ++i;
            }
        }
        return wbuf.toString();
    }

    public String getClassPath() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String projectString = "";
        int i = 0;
        while (i < projects.length) {
            IProject proj = projects[i];
            projectString = String.valueOf(projectString) + proj.getName() + PROPERTYSEPARATOR;
            ++i;
        }
        return this.getClassPath(projectString);
    }

    private List getProjectPaths(String projectName) {
        ArrayList<String> retValue = new ArrayList<String>();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectName == null) {
            return retValue;
        }
        List paths = this.getProjectPath(project);
        int j = 0;
        while (j < paths.size()) {
            URL url = (URL)paths.get(j);
            if (url != null) {
                retValue.add(url.getPath());
            }
            ++j;
        }
        String url = this.getProjectOutClassPath(project);
        if (url != null) {
            retValue.add(url);
        }
        return retValue;
    }

    private String getProjectOutClassPath(IProject project) {
        boolean projectExists;
        if (!this.hasJavaNature(project)) {
            return null;
        }
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IPath path = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && path == null) {
            path = fCurrJProject.readOutputLocation();
            String absPath = this.getFullPath(path, project);
            return absPath;
        }
        return null;
    }

    private List getProjectPath(IProject project) {
        boolean projectExists;
        List retValue = new ArrayList();
        if (!this.hasJavaNature(project)) {
            return retValue;
        }
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpathEntries = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && classpathEntries == null) {
            classpathEntries = fCurrJProject.readRawClasspath();
        }
        if (classpathEntries != null) {
            retValue = this.getExistingEntries(classpathEntries, project);
        }
        return retValue;
    }

    private List getExistingEntries(IClasspathEntry[] classpathEntries, IProject project) {
        ArrayList<URL> newClassPath = new ArrayList<URL>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            if (curr.getEntryKind() == 1) {
                try {
                    IPath path;
                    IWorkspaceRoot root;
                    boolean inWorkSpace = true;
                    IWorkspace space = ResourcesPlugin.getWorkspace();
                    if (space == null || space.getRoot() == null) {
                        inWorkSpace = false;
                    }
                    if ((root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path = curr.getPath()) == null) {
                        inWorkSpace = false;
                    }
                    if (inWorkSpace) {
                        String absPath = this.getFullPath(path, root.findMember(path).getProject());
                        URL url = new URL("file:///" + absPath);
                        newClassPath.add(url);
                    } else {
                        newClassPath.add(curr.getPath().toFile().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return newClassPath;
    }

    private String getFullPath(IPath path, IProject project) {
        String directPath;
        try {
            directPath = project.getDescription().getLocationURI().toURL().getPath();
        }
        catch (Exception e) {
            directPath = project.getLocation().toOSString();
        }
        String curPath = path.toOSString();
        int index = curPath.substring(1).indexOf(File.separator);
        String absPath = String.valueOf(directPath) + curPath.substring(index + 1);
        return absPath;
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

