/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import uk.co.spudsoft.birt.emitters.excel.Area;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.CellImage;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class HandlerState {
    private IContentEmitter emitter;
    private Logger log;
    private StyleManagerUtils smu;
    private IHandler handler;
    private Workbook wb;
    private StyleManager sm;
    private IRenderOption renderOptions;
    private ReportEngine reportEngine;
    public Sheet currentSheet;
    public List<CellImage> images = new ArrayList<CellImage>();
    public String sheetName;
    public String sheetPassword;
    public int rowNum;
    public int colNum;
    public float requiredRowHeightInPoints;
    public int rowOffset;
    public int colOffset;
    public boolean reportEnding;
    public List<AreaBorders> areaBorders = new ArrayList<AreaBorders>();
    public List<Area> rowSpans = new ArrayList<Area>();
    public Map<String, Integer> sheetNames = new HashMap<String, Integer>();
    public static final int MAX_SHEET_NAME_LENGTH = 31;
    public static final String[] ILLEGAL_SHEET_NAME_CHARACTERS = new String[]{"\\", "/", "*", "[", "]", ":", "?"};

    public HandlerState(IContentEmitter emitter, Logger log, StyleManagerUtils smu, Workbook wb, StyleManager sm, IRenderOption renderOptions) {
        this.emitter = emitter;
        this.log = log;
        this.smu = smu;
        this.wb = wb;
        this.sm = sm;
        this.renderOptions = renderOptions;
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    public Logger getLog() {
        return this.log;
    }

    public StyleManagerUtils getSmu() {
        return this.smu;
    }

    public Workbook getWb() {
        return this.wb;
    }

    public StyleManager getSm() {
        return this.sm;
    }

    public IRenderOption getRenderOptions() {
        return this.renderOptions;
    }

    public ReportEngine getReportEngine() {
        return this.reportEngine;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IHandler handler) {
        this.handler = handler;
        this.handler.notifyHandler(this);
    }

    public void insertBorderOverload(AreaBorders defn) {
        if (this.areaBorders == null) {
            this.areaBorders = new ArrayList<AreaBorders>();
        }
        this.areaBorders.add(defn);
    }

    public void removeBorderOverload(AreaBorders defn) {
        if (this.areaBorders != null) {
            this.areaBorders.remove(defn);
        }
    }

    public boolean cellIsMergedWithBorders(int row, int column) {
        if (this.areaBorders != null) {
            for (AreaBorders areaBorder : this.areaBorders) {
                if (!areaBorder.isMergedCells || areaBorder.top != row || areaBorder.left != column) continue;
                return true;
            }
        }
        return false;
    }

    public boolean rowHasMergedCellsWithBorders(int row) {
        if (this.areaBorders != null) {
            for (AreaBorders areaBorder : this.areaBorders) {
                if (!areaBorder.isMergedCells || areaBorder.top > row || areaBorder.bottom < row) continue;
                return true;
            }
        }
        return false;
    }

    public Area addRowSpan(int rowX, int colX, int rowY, int colY) {
        this.log.debug("addRowSpan [" + rowX + "," + colX + "] - [" + rowY + "," + colY + "]");
        Area area = new Area(new Coordinate(rowX, colX), new Coordinate(rowY, colY));
        this.rowSpans.add(area);
        return area;
    }

    public int computeNumberSpanBefore(int row, int col) {
        int i = 0;
        for (Area a : this.rowSpans) {
            this.log.debug("Considering span [ ", a.x.getRow(), ",", a.x.getCol(), "]-[", a.y.getRow(), ",", a.y.getCol(), "] for ", row, ",", col);
            if (a.y.getRow() < row) continue;
            if (a.x.getCol() <= col) {
                col += a.y.getCol() - a.x.getCol() + 1;
            }
            if (row <= a.x.getRow() || a.x.getCol() > col) continue;
            i += a.y.getCol() - a.x.getCol() + 1;
        }
        return i;
    }

    public boolean rowHasSpans(int row) {
        for (Area a : this.rowSpans) {
            if (a.y.getRow() < row) continue;
            return true;
        }
        return false;
    }

    public float calculateRowSpanHeightRequirement(int row) {
        float result = 0.0f;
        for (Area a : this.rowSpans) {
            if (a.y.getRow() < row) continue;
            float heightUnaccountedFor = a.height;
            int componentRow = a.x.getRow();
            while (componentRow < row) {
                heightUnaccountedFor -= this.currentSheet.getRow(componentRow).getHeightInPoints();
                ++componentRow;
            }
            float heightPerRowRemainig = heightUnaccountedFor / (float)(1 + a.y.getRow() - row);
            if (!(heightPerRowRemainig > result)) continue;
            result = heightPerRowRemainig;
        }
        return result;
    }

    public void clearRowSpans() {
        this.rowSpans.clear();
    }

    public int findRowsSpanned(int rowX, int colX) {
        for (Area a : this.rowSpans) {
            if (a.x.getRow() != rowX || a.x.getCol() != colX) continue;
            return a.y.getRow() - a.x.getRow();
        }
        return 0;
    }

    public String correctSheetName(String sheetName) {
        if (sheetName == null) {
            return null;
        }
        String correctedSheetName = sheetName;
        String[] stringArray = ILLEGAL_SHEET_NAME_CHARACTERS;
        int n = ILLEGAL_SHEET_NAME_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            String illegalChar = stringArray[n2];
            correctedSheetName = correctedSheetName.replace(illegalChar, "");
            ++n2;
        }
        if ("history".equalsIgnoreCase(correctedSheetName)) {
            return "history-sheet";
        }
        if (correctedSheetName.length() > 31) {
            correctedSheetName = correctedSheetName.substring(0, 31);
        }
        return correctedSheetName;
    }

    public String prepareSheetName() throws BirtException {
        String sheetName = this.sheetName;
        if (sheetName == null) {
            return null;
        }
        String preparedName = sheetName;
        Integer previousNameCount = 1;
        while (true) {
            Integer nameCount;
            if ((nameCount = this.sheetNames.get(sheetName)) == null) {
                this.sheetNames.put(sheetName, previousNameCount);
                return preparedName;
            }
            nameCount = nameCount + 1;
            preparedName = String.valueOf(sheetName) + " " + nameCount;
            int correction = preparedName.length() - 31;
            if (correction <= 0) {
                this.sheetNames.put(sheetName, nameCount);
                return preparedName;
            }
            if (correction > sheetName.length()) {
                throw new BirtException(EmitterServices.getPluginName(), "Unable to fit sheet name into the maximum allowed length", null);
            }
            sheetName = sheetName.substring(0, sheetName.length() - correction);
            preparedName = String.valueOf(sheetName) + " " + nameCount;
            previousNameCount = nameCount;
        }
    }
}

