/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.type.ConeChart;
import org.eclipse.birt.chart.ui.swt.type.PyramidChart;
import org.eclipse.birt.chart.ui.swt.type.TubeChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BarSeriesAttributeComposite
extends Composite
implements Listener {
    protected FillChooserComposite fccRiserOutline = null;
    protected Series series = null;
    protected ChartWizardContext context;
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public BarSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof BarSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "BarSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        this.initContextHelp(parent, context);
    }

    private void initContextHelp(Composite parent, ChartWizardContext context) {
        String contextHelpID = "org.eclipse.birt.chart.cshelp.FormatBarChartYSeries_ID";
        IChartType ct = context.getChartType();
        if (ct instanceof TubeChart) {
            contextHelpID = "org.eclipse.birt.chart.cshelp.FormatTubeChartYSeries_ID";
        } else if (ct instanceof PyramidChart) {
            contextHelpID = "org.eclipse.birt.chart.cshelp.FormatPyramidChartYSeries_ID";
        } else if (ct instanceof ConeChart) {
            contextHelpID = "org.eclipse.birt.chart.cshelp.FormatConeChartYSeries_ID";
        }
        ChartUIUtil.bindHelp((Control)parent, (String)contextHelpID);
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    protected void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        Label lblRiserOutline = new Label((Composite)this, 0);
        GridData gdLBLRiserOutline = new GridData();
        lblRiserOutline.setLayoutData((Object)gdLBLRiserOutline);
        lblRiserOutline.setText(Messages.getString("BarSeriesAttributeComposite.Lbl.SeriesOutline"));
        this.fccRiserOutline = new FillChooserComposite(this, 0, this.context, (Fill)((BarSeries)this.series).getRiserOutline(), false, false, true, true);
        GridData gdFCCRiserOutline = new GridData(768);
        this.fccRiserOutline.setLayoutData(gdFCCRiserOutline);
        this.fccRiserOutline.addListener(this);
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccRiserOutline) && event.type == 1) {
            ((BarSeries)this.series).setRiserOutline((ColorDefinition)event.data);
        }
    }
}

