/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SortedAggregationRowArray;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationsExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.sort.DimensionSortEvalHelper;
import org.mozilla.javascript.Scriptable;

public class QueryExecutorUtil {
    public static IAggregationResultSet[] applyFilterOnOperation(BirtCubeView view, CubeQueryExecutorHelper cubeQueryExecutorHelper, CubeQueryExecutor executor, AggregationDefinition[] finalAggregation, IAggregationResultSet[] rs, IBindingValueFetcher fetcher, StopSign stopSign) throws DataException, IOException, BirtException {
        if (!executor.getNestAggregationFilterEvalHelpers().isEmpty() && (view.getCubeQueryExecutionHints() == null || view.getCubeQueryExecutionHints().canExecuteCubeOperation())) {
            CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
            rs = coe.execute(rs, stopSign, fetcher);
            cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getNestAggregationFilterEvalHelpers());
            cubeQueryExecutorHelper.applyAggrFilters(finalAggregation, rs, stopSign);
        }
        return rs;
    }

    public static void populateAggregationSort(CubeQueryExecutor executor, CubeQueryExecutorHelper cubeQueryExcutorHelper, int type) throws DataException {
        List columnSort;
        switch (type) {
            case 2: {
                columnSort = executor.getColumnEdgeSort();
                break;
            }
            case 1: {
                columnSort = executor.getRowEdgeSort();
                break;
            }
            case 3: {
                columnSort = executor.getPageEdgeSort();
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < columnSort.size()) {
            block21: {
                ITargetSort targetSort;
                block20: {
                    DimLevel[] aggrOnLevels;
                    String bindingName;
                    ICubeSortDefinition cubeSort;
                    block23: {
                        List aggrOns;
                        block22: {
                            IBinding referBinding;
                            String expr;
                            ICubeQueryDefinition queryDefn;
                            block19: {
                                cubeSort = (ICubeSortDefinition)columnSort.get(i);
                                queryDefn = executor.getCubeQueryDefinition();
                                expr = cubeSort.getExpression().getText();
                                targetSort = null;
                                if ((cubeSort.getAxisQualifierLevels().length != 0 || !OlapExpressionUtil.isComplexDimensionExpr(expr) && !OlapExpressionUtil.isReferenceToAttribute(cubeSort.getExpression(), queryDefn.getBindings())) && OlapExpressionUtil.isDirectRerenrence(cubeSort.getExpression(), executor.getCubeQueryDefinition().getBindings())) break block19;
                                Scriptable scope = executor.getSession().getSharedScope();
                                targetSort = new DimensionSortEvalHelper(executor.getOuterResults(), scope, queryDefn, cubeSort, executor.getSession().getEngineContext().getScriptContext());
                                break block20;
                            }
                            bindingName = OlapExpressionUtil.getBindingName(expr);
                            if (bindingName == null) break block21;
                            List bindings = queryDefn.getBindings();
                            aggrOns = null;
                            IBinding binding = null;
                            int j = 0;
                            while (j < bindings.size()) {
                                binding = (IBinding)bindings.get(j);
                                if (binding.getBindingName().equals(bindingName)) {
                                    aggrOns = binding.getAggregatOns();
                                    break;
                                }
                                ++j;
                            }
                            aggrOnLevels = null;
                            if (aggrOns != null && aggrOns.size() != 0) break block22;
                            if (binding == null) break block21;
                            String measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure");
                            if (measureName == null && (referBinding = OlapExpressionUtil.getDirectMeasureBinding(binding, bindings)) != null) {
                                measureName = OlapExpressionUtil.getMeasure(referBinding.getExpression());
                                bindingName = referBinding.getBindingName();
                                aggrOns = referBinding.getAggregatOns();
                                if (referBinding.getAggrFunction() == null && (aggrOns == null || aggrOns.size() == 0)) {
                                    aggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
                                }
                            }
                            if (aggrOns != null && aggrOns.size() > 0) {
                                aggrOnLevels = new DimLevel[aggrOns.size()];
                                int j2 = 0;
                                while (j2 < aggrOnLevels.length) {
                                    aggrOnLevels[j2] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j2).toString());
                                    ++j2;
                                }
                            }
                            break block23;
                        }
                        aggrOnLevels = new DimLevel[aggrOns.size()];
                        int j = 0;
                        while (j < aggrOnLevels.length) {
                            aggrOnLevels[j] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                            ++j;
                        }
                    }
                    DimLevel[] axisLevels = new DimLevel[cubeSort.getAxisQualifierLevels().length];
                    int k = 0;
                    while (k < axisLevels.length) {
                        axisLevels[k] = new DimLevel(cubeSort.getAxisQualifierLevels()[k]);
                        ++k;
                    }
                    targetSort = new AggrSortDefinition(aggrOnLevels, bindingName, axisLevels, cubeSort.getAxisQualifierValues(), new DimLevel(cubeSort.getTargetLevel()), cubeSort.getSortDirection());
                }
                switch (type) {
                    case 2: {
                        cubeQueryExcutorHelper.addColumnSort(targetSort);
                        break;
                    }
                    case 1: {
                        cubeQueryExcutorHelper.addRowSort(targetSort);
                        break;
                    }
                    case 3: {
                        cubeQueryExcutorHelper.addPageSort(targetSort);
                    }
                }
            }
            ++i;
        }
    }

    public static AggregationDefinition[] prepareCube(ICubeQueryDefinition query, CalculatedMember[] calculatedMember, Scriptable scope, ScriptContext cx) throws DataException {
        int i;
        int index;
        int[] sortType;
        DimLevel[] levelsForFilter;
        IEdgeDefinition columnEdgeDefn = query.getEdge(2);
        ILevelDefinition[] levelsOnColumn = CubeQueryDefinitionUtil.getLevelsOnEdge(columnEdgeDefn);
        IEdgeDefinition rowEdgeDefn = query.getEdge(1);
        ILevelDefinition[] levelsOnRow = CubeQueryDefinitionUtil.getLevelsOnEdge(rowEdgeDefn);
        IEdgeDefinition pageEdgeDefn = query.getEdge(3);
        ILevelDefinition[] levelsOnPage = CubeQueryDefinitionUtil.getLevelsOnEdge(pageEdgeDefn);
        ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
        if (columnEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnColumn.length + levelsOnPage.length];
            sortType = new int[levelsOnColumn.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnColumn.length) {
                levelsForFilter[index] = new DimLevel(levelsOnColumn[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (rowEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnRow.length + levelsOnPage.length];
            sortType = new int[levelsOnRow.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnRow.length) {
                levelsForFilter[index] = new DimLevel(levelsOnRow[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (pageEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnPage.length];
            sortType = new int[levelsOnPage.length];
            int i2 = 0;
            while (i2 < levelsOnPage.length) {
                levelsForFilter[i2] = new DimLevel(levelsOnPage[i2]);
                sortType[i2] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i2], query);
                ++i2;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        AggregationDefinition[] fromCalculatedMembers = CubeQueryDefinitionUtil.createAggregationDefinitons(calculatedMember, query, scope, cx);
        aggregations.addAll(Arrays.asList(fromCalculatedMembers));
        return aggregations.toArray(new AggregationDefinition[0]);
    }

    public static void validateLimitSetting(BirtCubeView cubeView, IAggregationResultSet[] rsArray) throws DataException {
        int limitSize;
        int count = 0;
        if (cubeView.getColumnEdgeView() != null) {
            if (cubeView.getAppContext() != null && (limitSize = QueryExecutorUtil.populateFetchLimitSize(cubeView.getAppContext().get(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE))) > 0 && limitSize < rsArray[count].length()) {
                throw new DataException("data.olap.ExceedColumnLimit", new Object[]{limitSize});
            }
            ++count;
        }
        if (cubeView.getRowEdgeView() != null) {
            if (cubeView.getAppContext() != null && (limitSize = QueryExecutorUtil.populateFetchLimitSize(cubeView.getAppContext().get(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE))) > 0 && limitSize < rsArray[count].length()) {
                throw new DataException("data.olap.ExceedRowLimit", new Object[]{limitSize});
            }
            ++count;
        }
    }

    private static int populateFetchLimitSize(Object propValue) {
        String fetchLimitSize;
        int fetchLimit = -1;
        String string = fetchLimitSize = propValue == null ? "-1" : propValue.toString();
        if (fetchLimitSize != null) {
            fetchLimit = Integer.parseInt(fetchLimitSize);
        }
        return fetchLimit;
    }

    public static IAggregationResultSet sortAggregationResultSet(IAggregationResultSet rs) throws IOException {
        SortedAggregationRowArray sarr = new SortedAggregationRowArray(rs);
        rs.close();
        return new AggregationResultSet(rs.getAggregationDefinition(), rs.getAllLevels(), sarr.getSortedRows(), rs.getKeyNames(), rs.getAttributeNames());
    }

    public static void initLoadedAggregationResultSets(IAggregationResultSet[] arss, AggregationDefinition[] ads) {
        assert (ads.length <= arss.length);
        int i = 0;
        while (i < ads.length) {
            CachedAggregationResultSet cars = (CachedAggregationResultSet)arss[i];
            cars.setAggregationDefinition(ads[i]);
            ++i;
        }
    }
}

