/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.explorer;

import java.util.Objects;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishTemplateWizard;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorPart;

public class PublishTemplateExplorerHandler
extends AbstractHandler {
    protected IFile selectedFile;

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        IEvaluationContext context;
        Object object;
        this.selectedFile = null;
        if (evaluationContext instanceof IEvaluationContext && (object = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof IStructuredSelection && (selection = (IStructuredSelection)object).size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)selection.getFirstElement();
        }
        if (this.selectedFile != null && (Objects.equals(this.selectedFile.getFileExtension(), "rptdesign") || Objects.equals(this.selectedFile.getFileExtension(), "rpttemplate"))) {
            String url = this.selectedFile.getLocation().toOSString();
            try {
                ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(url);
                if (handle != null) {
                    handle.close();
                    this.setBaseEnabled(true);
                    return;
                }
            }
            catch (DesignFileException designFileException) {
                // empty catch block
            }
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedFile != null) {
            String url = this.selectedFile.getLocation().toOSString();
            try {
                ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(url);
                IEditorPart editor = org.eclipse.birt.report.designer.internal.ui.util.UIUtil.findOpenedEditor((String)url);
                if (editor != null && editor.isDirty()) {
                    MessageDialog md = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.title"), null, Messages.getFormattedString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.message", (Object[])new Object[]{this.selectedFile.getName()}), 5, new String[]{Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.button.yes"), Messages.getString((String)"PublishTemplateAction.SaveBeforeGenerating.dialog.button.no")}, 0);
                    switch (md.open()) {
                        case 0: {
                            editor.doSave(null);
                        }
                    }
                }
                BaseWizardDialog dialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)new PublishTemplateWizard(handle));
                dialog.setPageSize(500, 250);
                dialog.open();
                handle.close();
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
                throw new ExecutionException("Error executing command", (Throwable)e);
            }
        }
        return null;
    }
}

