/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;
import org.eclipse.birt.report.engine.internal.content.wrap.TableContentWrapper;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class TableContentLayout {
    public final Integer MAX_ROW_SPAN = 10000;
    Row[] rows;
    int rowCount;
    int colCount;
    int realColCount;
    int rowBufferSize;
    int colBufferSize;
    boolean isRowHidden;
    String format;
    ArrayList hiddenColumnIds = new ArrayList();
    ArrayList visibleColumns = new ArrayList();
    protected UnresolvedRowHint rowHint;
    protected Row lastRow = null;
    protected boolean formalized = false;
    protected HTMLLayoutContext context;
    private TableContentWrapper wrappedTable;
    private ITableContent tableContent;
    private boolean hasHiddenColumns = false;
    private int leastColumnIdToBeAjusted = 0;
    private int[] adjustedColumnIds;
    protected String keyString;
    protected boolean needFormalize = false;

    public TableContentLayout(ITableContent tableContent, String format, HTMLLayoutContext context, String keyString) {
        int current;
        this.format = format;
        this.context = context;
        this.tableContent = tableContent;
        this.keyString = keyString;
        this.colCount = tableContent.getColumnCount();
        boolean start = false;
        int end = this.colCount;
        String tableId = tableContent.getInstanceID().toUniqueString();
        List hints = context.getPageHintManager().getTableColumnHint(tableId);
        this.adjustedColumnIds = new int[this.colCount];
        int i = 0;
        while (i < this.colCount) {
            this.adjustedColumnIds[i] = -1;
            ++i;
        }
        if (hints.size() > 0) {
            int i2;
            current = -1;
            for (int[] hint : hints) {
                i2 = hint[0];
                while (i2 < hint[1]) {
                    IColumn column = tableContent.getColumn(i2);
                    if (!this.isColumnHidden(column)) {
                        this.visibleColumns.add(column);
                        ++current;
                    }
                    this.adjustedColumnIds[i2] = current >= 0 ? current : 0;
                    ++i2;
                }
            }
            int maxColId = Math.max(0, current);
            current = -1;
            i2 = 0;
            while (i2 < this.colCount) {
                if (this.adjustedColumnIds[i2] == -1) {
                    this.adjustedColumnIds[i2] = Math.min(maxColId, current + 1);
                } else {
                    current = this.adjustedColumnIds[i2];
                }
                if (!this.hasHiddenColumns && i2 != this.adjustedColumnIds[i2]) {
                    this.hasHiddenColumns = true;
                    this.leastColumnIdToBeAjusted = i2;
                }
                ++i2;
            }
        } else {
            current = -1;
            int i3 = 0;
            while (i3 < this.colCount) {
                IColumn column = tableContent.getColumn(i3);
                if (!this.isColumnHidden(column)) {
                    this.visibleColumns.add(column);
                    ++current;
                } else if (!this.hasHiddenColumns) {
                    this.hasHiddenColumns = true;
                    this.leastColumnIdToBeAjusted = i3;
                }
                this.adjustedColumnIds[i3] = current >= 0 ? current : 0;
                ++i3;
            }
        }
        if (this.hasHiddenColumns) {
            this.wrappedTable = new TableContentWrapper(tableContent, this.visibleColumns);
        }
        this.realColCount = this.visibleColumns.size();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void setUnresolvedRowHint(UnresolvedRowHint rowHint) {
        this.rowHint = rowHint;
    }

    public void endRow(IRowContent rowContent) {
        ICellContent cellContent;
        IReportContent report;
        Cell cell;
        int cellId;
        Cell[] cells;
        Row row;
        if (this.isRowHidden) {
            return;
        }
        if (this.rowHint != null && !this.formalized && !LayoutUtil.isRepeatableRow(rowContent)) {
            row = this.rows[this.rowCount - 1];
            cells = row.cells;
            cellId = 0;
            while (cellId < this.realColCount) {
                cell = cells[cellId];
                if (cell != null && (cell.status == 0 || cell.status == 1 && this.rowHint.isDropColumn(cellId))) {
                    Cell newCell;
                    report = rowContent.getReportContent();
                    cellContent = report.createCellContent();
                    this.rowHint.initUnresolvedCell(cellContent, rowContent.getInstanceID(), cellId);
                    cellContent.setParent(rowContent);
                    int rowSpan = cellContent.getRowSpan();
                    int colSpan = cellContent.getColSpan();
                    row.cells[cellId] = newCell = Cell.createCell(row.rowId, cellId, rowSpan, colSpan, new HTMLTableLayoutEmitter.CellContent(cellContent, null));
                    int end = Math.min(this.realColCount, cellId + colSpan);
                    int i = cellId + 1;
                    while (i < end) {
                        row.cells[i] = Cell.createSpanCell(row.rowId, i, newCell);
                        ++i;
                    }
                }
                ++cellId;
            }
            this.formalized = true;
            this.rowHint = null;
        }
        if (this.needFormalize) {
            if (this.hasDropCell()) {
                row = this.rows[this.rowCount - 1];
                cells = row.cells;
                cellId = 0;
                while (cellId < this.realColCount) {
                    cell = cells[cellId];
                    if (cell != null && cell.status == 0) {
                        Cell newCell;
                        report = rowContent.getReportContent();
                        cellContent = report.createCellContent();
                        cellContent.getStyle().setDisplay("none");
                        cellContent.setParent(rowContent);
                        row.cells[cellId] = newCell = Cell.createCell(row.rowId, cellId, 1, 1, new HTMLTableLayoutEmitter.CellContent(cellContent, null));
                    }
                    ++cellId;
                }
            }
            this.needFormalize = false;
        }
    }

    public void reset() {
        this.fillEmptyCells(0, 0, this.rowBufferSize, this.colBufferSize);
        this.rowCount = 0;
        this.isRowHidden = false;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.realColCount;
    }

    public boolean exceedMaxCache() {
        return this.rowCount >= this.MAX_ROW_SPAN;
    }

    public void setNeedFormalize(boolean formalize) {
        this.needFormalize = formalize;
    }

    public Row createRow(Object rowContent, boolean isHidden) {
        if (!isHidden) {
            this.isRowHidden = false;
            this.ensureSize(this.rowCount + 1, this.realColCount);
            Row row = this.rows[this.rowCount];
            row.rowId = this.rowCount;
            row.content = rowContent;
            if (this.rowCount > 0) {
                Cell[] cells = row.cells;
                Cell[] lastCells = this.rows[this.rowCount - 1].cells;
                int cellId = 0;
                while (cellId < this.realColCount) {
                    Cell lastCell = lastCells[cellId];
                    if (lastCell.status == 2) {
                        lastCell = lastCell.getCell();
                    }
                    if (lastCell.status == 1 && (lastCell.rowSpan < 0 || lastCell.rowId + lastCell.rowSpan > this.rowCount)) {
                        cells[cellId] = Cell.createSpanCell(this.rowCount, cellId, lastCell);
                    }
                    ++cellId;
                }
            }
            ++this.rowCount;
            return row;
        }
        this.isRowHidden = true;
        if (this.rowCount > 0) {
            Cell[] lastCells = this.rows[this.rowCount - 1].cells;
            HashSet<Cell> updated = new HashSet<Cell>();
            int cellId = 0;
            while (cellId < this.realColCount) {
                Cell lastCell = lastCells[cellId];
                if (lastCell.status == 2) {
                    lastCell = lastCell.getCell();
                }
                if (lastCell.status == 1 && lastCell.rowId + lastCell.rowSpan >= this.rowCount + 1 && !updated.contains(lastCell)) {
                    --lastCell.rowSpan;
                    updated.add(lastCell);
                }
                ++cellId;
            }
        }
        return null;
    }

    public void createCell(int cellId, int rowSpan, int colSpan, Cell.Content content) {
        block10: {
            Cell lastCell;
            int status;
            int columnSpan;
            int columnNumber;
            block9: {
                if (this.isRowHidden) {
                    return;
                }
                columnNumber = cellId;
                columnSpan = colSpan;
                if (this.wrappedTable != null) {
                    columnNumber = this.getAdjustedColumnId(cellId);
                    columnSpan = this.getAdjustedColumnSpan(cellId, colSpan);
                }
                if (columnSpan < 1) {
                    return;
                }
                assert (columnNumber >= 0);
                assert (columnNumber + columnSpan <= this.realColCount);
                this.ensureSize(this.rowCount, columnNumber + columnSpan);
                Cell cell = this.rows[this.rowCount - 1].cells[columnNumber];
                status = cell.getStatus();
                if (status != 0) break block9;
                Cell newCell = Cell.createCell(this.rows[this.rowCount - 1].rowId, columnNumber, rowSpan, columnSpan, content);
                Cell[] cells = this.rows[this.rowCount - 1].cells;
                this.rows[this.rowCount - 1].cells[columnNumber] = newCell;
                int i = columnNumber + 1;
                while (i < columnNumber + columnSpan) {
                    cells[i] = Cell.createSpanCell(this.rows[this.rowCount - 1].rowId, i, newCell);
                    ++i;
                }
                break block10;
            }
            if (status != 2 || this.rowCount <= 1 || (lastCell = this.rows[this.rowCount - 2].cells[columnNumber]).getRowSpan() <= 0) break block10;
            if (lastCell.status == 2) {
                lastCell = lastCell.getCell();
            }
            if (lastCell.status == 1) {
                lastCell.rowSpan = this.rowCount - 1 - lastCell.rowId;
            }
            Cell newCell = Cell.createCell(this.rows[this.rowCount - 1].rowId, columnNumber, rowSpan, columnSpan, content);
            Cell[] cells = this.rows[this.rowCount - 1].cells;
            this.rows[this.rowCount - 1].cells[columnNumber] = newCell;
            int i = columnNumber + 1;
            while (i < columnNumber + columnSpan) {
                cells[i] = Cell.createSpanCell(this.rows[this.rowCount - 1].rowId, i, newCell);
                ++i;
            }
        }
    }

    public void resolveDropCells(boolean finished) {
        if (!finished) {
            this.keepUnresolvedCells();
        }
        if (this.rowCount <= 0) {
            return;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            if (cells[cellId] != null) {
                if (cells[cellId].getRowSpan() != 1) {
                    Cell cell = cells[cellId].getCell();
                    cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId + 1;
                }
                cellId = cellId + cells[cellId].getColSpan() - 1;
            }
            ++cellId;
        }
    }

    public void resolveDropCells(int bandId, boolean finished) {
        if (this.rowCount <= 0) {
            return;
        }
        if (!finished) {
            this.keepUnresolvedCells();
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            if (cells[cellId] != null) {
                Cell cell = cells[cellId].getCell();
                if (cell.getRowSpan() == bandId) {
                    cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId + 1;
                }
                cellId = cellId + cells[cellId].getColSpan() - 1;
            }
            ++cellId;
        }
    }

    public boolean hasUnResolvedRow() {
        return this.rowHint != null;
    }

    public boolean hasDropCell() {
        if (this.rowCount <= 0) {
            return false;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        int cellId = 0;
        while (cellId < this.realColCount) {
            int rowSpan;
            Cell cell = cells[cellId];
            if (cell != null && ((rowSpan = cell.getRowSpan()) < 0 || rowSpan > 1)) {
                return true;
            }
            ++cellId;
        }
        return false;
    }

    protected void ensureSize(int newRowBufferSize, int newColBufferSize) {
        if (newRowBufferSize > this.rowBufferSize) {
            Row[] newRows = new Row[newRowBufferSize];
            if (this.rows != null) {
                System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
            }
            int rowId = this.rowBufferSize;
            while (rowId < newRowBufferSize) {
                Row row = new Row(rowId);
                Cell[] cells = new Cell[this.colBufferSize];
                int colId = 0;
                while (colId < this.colBufferSize) {
                    cells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = cells;
                newRows[rowId] = row;
                ++rowId;
            }
            this.rows = newRows;
            this.rowBufferSize = newRowBufferSize;
        }
        if (newColBufferSize > this.colBufferSize) {
            int rowId = 0;
            while (rowId < this.rowBufferSize) {
                Row row = this.rows[rowId];
                Cell[] newCells = new Cell[newColBufferSize];
                if (row.cells != null) {
                    System.arraycopy(row.cells, 0, newCells, 0, this.colBufferSize);
                }
                int colId = this.colBufferSize;
                while (colId < newColBufferSize) {
                    newCells[colId] = Cell.EMPTY_CELL;
                    ++colId;
                }
                row.cells = newCells;
                ++rowId;
            }
            this.colBufferSize = newColBufferSize;
        }
    }

    protected void fillEmptyCells(int rowId, int colId, int rowSize, int colSize) {
        int i;
        int lastRowId = rowId + rowSize;
        int lastColId = colId + colSize;
        if (lastRowId > this.rowCount) {
            lastRowId = this.rowCount;
        }
        if (lastColId > this.colCount) {
            lastColId = this.colCount;
        }
        if (lastRowId > 0 && this.rows[lastRowId - 1] != null) {
            this.lastRow = new Row(this.rows[lastRowId - 1].rowId);
            this.lastRow.content = this.rows[lastRowId - 1].content;
            this.lastRow.cells = new Cell[lastColId - colId];
            i = colId;
            while (i < lastColId) {
                this.lastRow.cells[i] = this.rows[lastRowId - 1].cells[i];
                ++i;
            }
        }
        i = rowId;
        while (i < lastRowId) {
            Cell[] cells = this.rows[i].cells;
            int j = colId;
            while (j < lastColId) {
                cells[j] = Cell.EMPTY_CELL;
                ++j;
            }
            ++i;
        }
    }

    protected void resizeCell(Cell cell, int newRowSpan, int newColSpan) {
        assert (cell.status == 1);
        int rowId = cell.rowId;
        int colId = cell.colId;
        int rowSpan = cell.rowSpan;
        if (rowSpan <= 0) {
            rowSpan = this.rowCount - rowId;
        }
        int colSpan = cell.colSpan;
        assert (rowSpan >= newRowSpan && colSpan >= newColSpan);
        this.fillEmptyCells(rowId, colId + newColSpan, rowSpan, colSpan - newColSpan);
        this.fillEmptyCells(rowId + newRowSpan, colId, rowSpan - newRowSpan, newColSpan);
        cell.colSpan = newColSpan;
        cell.rowSpan = newRowSpan;
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this.rows[rowIndex].cells[colIndex];
    }

    public Row getRow(int index) {
        assert (index >= 0 && index < this.rowCount);
        return this.rows[index];
    }

    private boolean isColumnHidden(IColumn column) {
        boolean hiddenMask = this.context.isFixedLayout() && (Integer)this.context.getLayoutEngine().getOption("task_type") == 1;
        return LayoutUtil.isHidden(column, this.format, this.context.getOutputDisplayNone(), hiddenMask);
    }

    public UnresolvedRowHint getUnresolvedRow() {
        return this.rowHint;
    }

    protected void keepUnresolvedCells() {
        if (this.rowHint == null) {
            Row row = null;
            if (this.rowCount > 0) {
                row = this.rows[this.rowCount - 1];
            } else if (this.lastRow != null) {
                row = this.lastRow;
            } else {
                return;
            }
            Cell[] cells = row.cells;
            IRowContent rowContent = (IRowContent)row.getContent();
            ITableContent table = rowContent.getTable();
            InstanceID tableId = table.getInstanceID();
            InstanceID rowId = rowContent.getInstanceID();
            UnresolvedRowHint hint = new UnresolvedRowHint(tableId.toUniqueString(), rowId.toUniqueString());
            int cellId = 0;
            while (cellId < this.realColCount) {
                if (cells[cellId] != null) {
                    ICellContent cc;
                    String style = null;
                    HTMLTableLayoutEmitter.CellContent cellContent = (HTMLTableLayoutEmitter.CellContent)cells[cellId].getContent();
                    if (cellContent != null && (cc = cellContent.getContent()) != null) {
                        style = cc.getStyle().getCssText();
                    }
                    hint.addUnresolvedCell(style, cells[cellId].getColId(), cells[cellId].getColSpan(), cells[cellId].getRowSpan());
                }
                ++cellId;
            }
            this.rowHint = hint;
        }
    }

    public int getCurrentRowID() {
        return this.rowCount - 1;
    }

    public boolean isVisible(ICellContent cell) {
        boolean hiddenMask;
        IElement parent = cell.getParent();
        boolean bl = hiddenMask = this.context.isFixedLayout() && (Integer)this.context.getLayoutEngine().getOption("task_type") == 1;
        if (parent instanceof IContent && LayoutUtil.isHidden((IContent)parent, this.format, this.context.getOutputDisplayNone(), hiddenMask)) {
            return false;
        }
        IColumn column = cell.getColumnInstance();
        return column != null && !this.isColumnHidden(column);
    }

    public ITableContent getWrappedTableContent() {
        if (this.wrappedTable != null) {
            return this.wrappedTable;
        }
        return this.tableContent;
    }

    public ICellContent getWrappedCellContent(ICellContent cellContent) {
        if (this.needWrap(cellContent)) {
            CellContentWrapper cellContentWrapper = new CellContentWrapper(cellContent);
            int columnId = cellContent.getColumn();
            int columnSpan = cellContent.getColSpan();
            cellContentWrapper.setColumn(this.getAdjustedColumnId(columnId));
            cellContentWrapper.setColSpan(this.getAdjustedColumnSpan(columnId, columnSpan));
            return cellContentWrapper;
        }
        return cellContent;
    }

    private boolean needWrap(ICellContent cellContent) {
        if (this.wrappedTable != null) {
            int columnId = cellContent.getColumn();
            int columnSpan = cellContent.getColSpan();
            return columnId >= this.leastColumnIdToBeAjusted || columnId + columnSpan - 1 >= this.leastColumnIdToBeAjusted;
        }
        return false;
    }

    public int getColumnId(int columnId) {
        if (this.wrappedTable != null) {
            return this.getAdjustedColumnId(columnId);
        }
        return columnId;
    }

    public int getColunmSpan(int columnId, int columnSpan) {
        if (this.wrappedTable != null) {
            return this.getAdjustedColumnSpan(columnId, columnSpan);
        }
        return columnSpan;
    }

    private int getAdjustedColumnSpan(int columnId, int columnSpan) {
        if (columnSpan == 1) {
            return columnSpan;
        }
        int endColumnId = columnId + columnSpan - 1;
        return this.adjustedColumnIds[endColumnId] - this.adjustedColumnIds[columnId] + 1;
    }

    private int getAdjustedColumnId(int columnId) {
        return this.adjustedColumnIds[columnId];
    }

    protected static class UnresolvedRow {
        Row row;
        boolean[] invalidFlags;

        public UnresolvedRow(Row row) {
            this.row = row;
            this.invalidFlags = new boolean[row.cells.length];
        }

        protected int getRowSpan(Row row, int originalRowSpan) {
            if (originalRowSpan > 0 && row.getContent() != this.row.getContent()) {
                return originalRowSpan - 1;
            }
            return originalRowSpan;
        }

        public Cell createCell(int colId, Row row) {
            Cell[] cells = this.row.cells;
            if (colId >= 0 && colId < cells.length && !this.invalidFlags[colId]) {
                this.invalidFlags[colId] = true;
                return Cell.createCell(row.rowId, colId, this.getRowSpan(row, cells[colId].getRowSpan()), cells[colId].getColSpan(), cells[colId].getContent());
            }
            return Cell.createCell(row.rowId, colId, 1, 1, cells[colId].getContent());
        }
    }
}

