/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.extension.IExtendedItem;
import org.eclipse.birt.report.engine.extension.IExtendedItemFactory;
import org.eclipse.birt.report.engine.extension.IReportEventHandler;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemPreparation;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ExtendedItemManager {
    ExtensionManager manager = ExtensionManager.getInstance();
    HashMap extFactories = new HashMap();
    HashMap extItems = new HashMap();

    protected IExtendedItem getExtendedItem(ExtendedItemHandle handle) {
        if (this.extItems.containsKey(handle)) {
            return (IExtendedItem)this.extItems.get(handle);
        }
        IExtendedItemFactory extFactory = null;
        IExtendedItem extItem = null;
        String tagName = handle.getExtensionName();
        if (this.extFactories.containsKey(tagName)) {
            extFactory = (IExtendedItemFactory)this.extFactories.get(tagName);
        } else {
            extFactory = this.manager.createExtendedItemFactory(tagName);
            this.extFactories.put(tagName, extFactory);
        }
        if (extFactory != null) {
            extItem = extFactory.createExtendedItem(handle);
        }
        this.extItems.put(handle, extItem);
        return extItem;
    }

    public IReportItemQuery createQuery(ExtendedItemHandle handle) {
        IExtendedItem extItem = this.getExtendedItem(handle);
        if (extItem != null) {
            return extItem.createQuery();
        }
        return this.manager.createQueryItem(handle.getExtensionName());
    }

    public IReportItemPresentation createPresentation(ExtendedItemHandle handle) {
        IExtendedItem extItem = this.getExtendedItem(handle);
        if (extItem != null) {
            return extItem.createPresentation();
        }
        return this.manager.createPresentationItem(handle.getExtensionName());
    }

    public IReportEventHandler createEventHandler(ExtendedItemHandle handle) {
        IExtendedItem extItem = this.getExtendedItem(handle);
        if (extItem != null) {
            return extItem.createEventHandler();
        }
        return this.manager.createEventHandler(handle.getExtensionName());
    }

    public IReportItemPreparation createPreparation(ExtendedItemHandle handle) {
        IExtendedItem extItem = this.getExtendedItem(handle);
        if (extItem != null) {
            return extItem.createPreparation();
        }
        return this.manager.createPreparationItem(handle.getExtensionName());
    }

    public IReportItemExecutor createExecutor(ExtendedItemHandle handle, ExecutorManager exeManager) {
        IExtendedItem extItem = this.getExtendedItem(handle);
        if (extItem != null) {
            return extItem.createExecutor();
        }
        return this.manager.createReportItemExecutor(exeManager, handle.getExtensionName());
    }

    public void close() {
        for (IExtendedItem extItem : this.extItems.values()) {
            if (extItem == null) continue;
            extItem.release();
        }
        for (IExtendedItemFactory extFactory : this.extFactories.values()) {
            if (extFactory == null) continue;
            extFactory.release();
        }
        this.extFactories.clear();
        this.extItems.clear();
    }
}

