/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class DriverUtil {
    public static final String EMPTY_STRING = "";
    private static Logger sm_logger = Logger.getLogger("org.eclipse.birt.data.oda.mongodb");

    public static Logger getLogger() {
        return sm_logger;
    }

    static Object parseJSONExpr(String jsonExpr) throws OdaException {
        try {
            return JSON.parse((String)jsonExpr);
        }
        catch (JSONParseException ex) {
            String errMsg = Messages.bind((String)Messages.driverUtil_parsingError, (Object)jsonExpr);
            DriverUtil.getLogger().log(Level.INFO, errMsg, ex);
            OdaException newEx = new OdaException(errMsg);
            newEx.initCause((Throwable)ex);
            throw newEx;
        }
    }

    static DBObject parseExprToDBObject(String jsonExpr) throws OdaException {
        Object parsedObj = DriverUtil.parseJSONExpr(jsonExpr);
        if (parsedObj instanceof DBObject) {
            return (DBObject)parsedObj;
        }
        throw new OdaException(Messages.bind((String)Messages.driverUtil_invalidExpr, (Object)parsedObj.getClass().getSimpleName()));
    }
}

