/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandleImpl;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.PropertyHandleHelper;

public class PropertyHandle
extends PropertyHandleImpl {
    public PropertyHandle(DesignElementHandle element, String propName) {
        super(element, propName);
    }

    public PropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
        super(element, prop);
    }

    @Override
    public boolean isReadOnly() {
        boolean isReadOnly = false;
        Module root = this.getElementHandle().getModule();
        assert (root != null);
        if (root.isReadOnly()) {
            isReadOnly = true;
        } else {
            switch (this.propDefn.getValueType()) {
                case 0: 
                case 2: 
                case 4: {
                    IElementDefn elementDefn = this.getElementHandle().getDefn();
                    if (!elementDefn.isPropertyReadOnly(this.propDefn.getName())) break;
                    isReadOnly = true;
                    break;
                }
                case 3: {
                    if (!this.propDefn.isReadOnly()) break;
                    isReadOnly = true;
                }
            }
        }
        if (isReadOnly) {
            return true;
        }
        return PropertyHandleHelper.getInstance().isReadOnlyInContext(this);
    }

    @Override
    public boolean isVisible() {
        boolean isVisible = true;
        switch (this.propDefn.getValueType()) {
            case 0: 
            case 2: 
            case 4: {
                IElementDefn elementDefn = this.getElementHandle().getDefn();
                if (elementDefn.isPropertyVisible(this.propDefn.getName())) break;
                isVisible = false;
                break;
            }
            case 3: {
                if (this.propDefn.isVisible()) break;
                isVisible = false;
                break;
            }
            case 1: {
                if (this.propDefn.isVisible()) break;
                isVisible = false;
            }
        }
        if (!isVisible) {
            return false;
        }
        return PropertyHandleHelper.getInstance().isVisibleInContext(this);
    }
}

