/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public abstract class DocObject {
    protected String description;
    protected String summary;
    protected String seeAlso;

    public abstract String getName();

    public String makeElementLink(String elementName, String dir) {
        StringBuilder link = new StringBuilder();
        link.append("<a href=\"");
        if (dir == null) {
            link.append("elements/");
        } else if (!dir.equals("elements")) {
            link.append("../elements/");
        }
        link.append(elementName);
        link.append(".html\">");
        link.append(elementName);
        link.append("</a>");
        return link.toString();
    }

    public String makeStructureLink(IStructureDefn struct, String dir) {
        StringBuilder link = new StringBuilder();
        link.append("<a href=\"");
        if (dir == null) {
            link.append("structs/");
        } else if (!dir.equals("structs")) {
            link.append("../structs/");
        }
        link.append(struct.getName());
        link.append(".html\">");
        link.append(struct.getName());
        link.append("</a>");
        return link.toString();
    }

    public String makeTypeLink(PropertyType type, String dir) {
        StringBuilder link = new StringBuilder();
        link.append("<a href=\"");
        if (dir != null) {
            link.append("../");
        }
        link.append("types.html#");
        link.append(type.getName());
        link.append("\">");
        link.append(type.getName());
        link.append("</a>");
        return link.toString();
    }

    public String yesNo(boolean flag) {
        return flag ? "Yes" : "No";
    }

    public String getDescription() {
        return this.description;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setSeeAlso(String string) {
        this.seeAlso = string;
    }

    public void setSummary(String string) {
        this.summary = string;
    }
}

