/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.image.ImageMapEmitter;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.SecurityUtil;

public abstract class JavaxImageIOWriter
extends SwingRendererImpl
implements IIOWriteWarningListener,
IImageMapEmitter {
    private boolean _bAltEnabled = false;
    protected Image _img = null;
    protected Object _oOutputIdentifier = null;
    private Bounds _bo = null;
    private boolean _bImageExternallySpecified = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/image");
    private String outputFormat;

    protected abstract String getFormat();

    protected abstract int getImageType();

    protected boolean supportsTransparency() {
        return true;
    }

    JavaxImageIOWriter() {
        ImageIO.setUseCache(false);
    }

    protected void updateWriterParameters(ImageWriteParam iwp) {
    }

    public String getImageMap() {
        return new ImageMapEmitter(this.getShapeActions(), this._bAltEnabled, this.getULocale(), this.getDisplayServer().getDpiResolution()).getImageMap();
    }

    protected boolean isSupportedByJavaxImageIO() {
        Iterator<ImageWriter> it;
        boolean supported = false;
        String s = this.getFormat();
        if (s != null && (it = ImageIO.getImageWritersByFormatName(s)).hasNext()) {
            supported = true;
        }
        if (!supported && (s = this.getMimeType()) != null && (it = ImageIO.getImageWritersByMIMEType(s)).hasNext()) {
            supported = true;
        }
        return supported;
    }

    @Override
    public void before() throws ChartException {
        super.before();
        boolean bl = this._bImageExternallySpecified = this._img != null;
        if (!this._bImageExternallySpecified) {
            if (this._bo == null) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.bounds", Messages.getResourceBundle(this.getULocale()));
            }
            if ((int)this._bo.getWidth() < 0 || (int)this._bo.getHeight() < 0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 18, "JavaxImageIOWriter.exception.invalid.image.size", Messages.getResourceBundle(this.getULocale()));
            }
            if ((int)this._bo.getWidth() == 0 || (int)this._bo.getHeight() == 0) {
                this._bo.setWidth(1.0);
                this._bo.setHeight(1.0);
            }
            this._img = new BufferedImage((int)Math.round(this._bo.getWidth()), (int)Math.round(this._bo.getHeight()), this.getImageType());
        }
        super.setProperty("device.output.context", this._img.getGraphics());
        if (!this.supportsTransparency()) {
            this._g2d.setPaint(Color.WHITE);
            this._g2d.fillRect(0, 0, this._img.getWidth(null), this._img.getHeight(null));
        }
    }

    @Override
    public void after() throws ChartException {
        super.after();
        if (this._oOutputIdentifier != null) {
            ImageWriter iw = ImageWriterFactory.instance().createImageWriter(this.getFormat(), this.outputFormat);
            if (iw == null) {
                String s = this.getMimeType();
                if (s == null) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.imagewriter.mimetype.and.format", new Object[]{this.getMimeType(), this.getFormat(), this.getClass().getName()}, Messages.getResourceBundle(this.getULocale()));
                }
                Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(s);
                if (!it.hasNext()) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "JavaxImageIOWriter.exception.no.imagewriter.mimetype", new Object[]{this.getMimeType()}, Messages.getResourceBundle(this.getULocale()));
                }
                iw = it.next();
            }
            logger.log(1, String.valueOf(Messages.getString("JavaxImageIOWriter.info.using.imagewriter", this.getULocale())) + this.getFormat() + iw.getClass().getName());
            Object o = this._oOutputIdentifier instanceof String ? new File((String)this._oOutputIdentifier) : this._oOutputIdentifier;
            try {
                try {
                    ImageOutputStream ios = SecurityUtil.newImageOutputStream((Object)o);
                    ImageWriteParam iwp = iw.getDefaultWriteParam();
                    this.updateWriterParameters(iwp);
                    iw.setOutput(ios);
                    iw.write(null, new IIOImage((BufferedImage)this._img, null, null), iwp);
                    ios.close();
                }
                catch (Exception ex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ex);
                }
            }
            finally {
                iw.dispose();
            }
        }
        if (!this._bImageExternallySpecified) {
            this._img.flush();
            this._img = null;
        }
        this._g2d.dispose();
        this._g2d = null;
    }

    @Override
    public void setProperty(String sProperty, Object oValue) {
        super.setProperty(sProperty, oValue);
        if (sProperty.equals("device.bounds")) {
            this._bo = (Bounds)oValue;
        } else if (sProperty.equals("cached.image")) {
            this._img = (Image)oValue;
        } else if (sProperty.equals("device.file.identifier")) {
            this._oOutputIdentifier = oValue;
        } else if (sProperty.equals("device.disk.cache")) {
            ImageIO.setUseCache((Boolean)oValue);
        } else if (sProperty.equals("enable.area.alt")) {
            this._bAltEnabled = (Boolean)oValue;
        } else if (sProperty.equals("output.format")) {
            this.outputFormat = (String)oValue;
        }
    }

    @Override
    public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
        logger.log(2, warning);
    }

    public void presentException(Exception cexp) {
        if (this._bo == null) {
            this._bo = BoundsImpl.create((double)0.0, (double)0.0, (double)400.0, (double)300.0);
        }
        String sWrappedException = cexp.getClass().getName();
        while (cexp.getCause() != null) {
            cexp = (Exception)cexp.getCause();
        }
        String sException = cexp.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = cexp.getMessage();
        StackTraceElement[] stea = cexp.getStackTrace();
        Dimension d = new Dimension((int)this._bo.getWidth(), (int)this._bo.getHeight());
        Font fo = new Font("Monospaced", 1, 14);
        this._g2d.setFont(fo);
        FontMetrics fm = this._g2d.getFontMetrics();
        this._g2d.setColor(Color.WHITE);
        this._g2d.fillRect(20, 20, d.width - 40, d.height - 40);
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawRect(20, 20, d.width - 40, d.height - 40);
        this._g2d.setClip(20, 20, d.width - 40, d.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.exception.caption", this.getULocale()), x, y);
        this._g2d.setColor(Color.RED);
        this._g2d.drawString(sException, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.exception.caption", this.getULocale())) + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            this._g2d.setColor(Color.BLACK);
            this._g2d.drawString(Messages.getString("JavaxImageIOWriter.wrapped.caption", this.getULocale()), x, y);
            this._g2d.setColor(Color.RED);
            this._g2d.drawString(sWrappedException, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.wrapped.caption", this.getULocale())) + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.message.caption", this.getULocale()), x, y += 10);
        this._g2d.setColor(Color.BLUE);
        this._g2d.drawString(sMessage, x += fm.stringWidth(Messages.getString("JavaxImageIOWriter.message.caption", this.getULocale())) + 5, y);
        x = 25;
        y += fm.getHeight();
        this._g2d.setColor(Color.BLACK);
        this._g2d.drawString(Messages.getString("JavaxImageIOWriter.trace.caption", this.getULocale()), x, y += 10);
        x = 40;
        y += fm.getHeight();
        this._g2d.setColor(Color.GREEN.darker());
        int i = 0;
        while (i < stea.length) {
            this._g2d.drawString(Messages.getString("JavaxImageIOWriter.trace.detail", new Object[]{stea[i].getClassName(), stea[i].getMethodName(), String.valueOf(stea[i].getLineNumber())}, this.getULocale()), x, y);
            x = 40;
            y += fm.getHeight();
            ++i;
        }
    }
}

