/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samplesview.sampleslocator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SampleReportsEntry
implements ResourceEntry {
    private static final String SAMPLE_REPORTS_HOST = "org.eclipse.birt.report.designer.samplereports";
    public static final Bundle samplesBundle = Platform.getBundle((String)"org.eclipse.birt.report.designer.samplereports");
    private String name;
    private String displayName;
    private SampleReportsEntry parent;
    private String path;
    private List children = new ArrayList();
    private ReportDesignHandle sampleReport;
    private boolean isRoot;
    private boolean isFile;

    public SampleReportsEntry(String[] filePattern, String entryname, String fragmentPath, SampleReportsEntry parentEntry, boolean isFile) {
        this(entryname, fragmentPath, parentEntry, false);
        this.isRoot = true;
        this.displayName = "BIRT Examples";
        if (samplesBundle != null && filePattern != null && filePattern.length > 0) {
            int i = 0;
            while (i < filePattern.length) {
                String[] patterns = filePattern[i].split(";");
                int j = 0;
                while (j < patterns.length) {
                    Enumeration enumeration = samplesBundle.findEntries(fragmentPath, patterns[j], true);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        URL element = (URL)enumeration.nextElement();
                        String path = String.valueOf(element.getPath()) + (element.getRef() != null ? "#" + element.getRef() : "");
                        String[] pathtoken = path.split("/");
                        SampleReportsEntry parent = this;
                        int m = 0;
                        while (m < pathtoken.length) {
                            if (!pathtoken[m].equals("") && !pathtoken[m].equals(fragmentPath.substring(fragmentPath.indexOf(47) + 1))) {
                                SampleReportsEntry child = parent.getChild(pathtoken[m]);
                                if (child == null) {
                                    child = new SampleReportsEntry(pathtoken[m], String.valueOf(parent.path.equals("/") ? "" : parent.path) + "/" + pathtoken[m], parent, m == pathtoken.length - 1);
                                }
                                parent = child;
                            }
                            ++m;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private SampleReportsEntry(String entryname, String fragmentPath, SampleReportsEntry parentEntry, boolean isFile) {
        this.name = entryname;
        this.path = fragmentPath;
        this.parent = parentEntry;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.isFile = isFile;
    }

    private void addChild(SampleReportsEntry entry) {
        this.children.add(entry);
    }

    private SampleReportsEntry getChild(String name) {
        for (SampleReportsEntry entry : this.children) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public ResourceEntry[] getChildren() {
        return this.children.toArray(new ResourceEntry[this.children.size()]);
    }

    public ResourceEntry[] getChildren(ResourceEntry.Filter filter) {
        ResourceEntry[] children = this.getChildren();
        ArrayList<ResourceEntry> childrenFiltered = new ArrayList<ResourceEntry>();
        int i = 0;
        while (i < children.length) {
            if (filter.accept(children[i])) {
                childrenFiltered.add(children[i]);
            }
            ++i;
        }
        return childrenFiltered.toArray(new ResourceEntry[childrenFiltered.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image getImage() {
        if (this.isRoot || this.hasChildren()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public ResourceEntry getParent() {
        return this.parent;
    }

    public URL getURL() {
        if (samplesBundle != null) {
            return samplesBundle.getResource(this.path);
        }
        return null;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void dispose() {
        if (this.sampleReport != null) {
            this.sampleReport.close();
            this.sampleReport = null;
        }
        ResourceEntry[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ReportDesignHandle.class) {
            if (!this.hasChildren() && this.sampleReport == null) {
                try {
                    this.sampleReport = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(this.getURL().toString());
                }
                catch (DesignFileException designFileException) {
                    // empty catch block
                }
            }
            return this.sampleReport;
        }
        if (adapter == ResourceEntry.class) {
            return this;
        }
        return null;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean hasChildren(ResourceEntry.Filter filter) {
        return this.getChildren(filter).length > 0;
    }
}

