/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.content.wrap;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.internal.content.wrap.AbstractContentWrapper;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class CellContentWrapper
extends AbstractContentWrapper
implements ICellContent {
    protected ICellContent cell;
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected int row = -1;

    public CellContentWrapper(ICellContent cell) {
        super(cell);
        this.cell = cell;
    }

    @Override
    public int getRowSpan() {
        if (this.rowSpan != -1) {
            return this.rowSpan;
        }
        return this.cell.getRowSpan();
    }

    @Override
    public int getColSpan() {
        if (this.colSpan != -1) {
            return this.colSpan;
        }
        return this.cell.getColSpan();
    }

    @Override
    public int getColumn() {
        if (this.column != -1) {
            return this.column;
        }
        return this.cell.getColumn();
    }

    @Override
    public int getRow() {
        if (this.row != -1) {
            return this.row;
        }
        return this.cell.getRow();
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitCell(this, value);
    }

    @Override
    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public boolean getDisplayGroupIcon() {
        return this.cell.getDisplayGroupIcon();
    }

    @Override
    public void setDisplayGroupIcon(boolean isStartOfGroup) {
        this.cell.setDisplayGroupIcon(isStartOfGroup);
    }

    @Override
    public IColumn getColumnInstance() {
        return this.cell.getColumnInstance();
    }

    @Override
    public IContent cloneContent(boolean isDeep) {
        if (isDeep) {
            throw new UnsupportedOperationException();
        }
        return new CellContentWrapper(this);
    }

    @Override
    public boolean hasDiagonalLine() {
        return this.cell.hasDiagonalLine();
    }

    @Override
    public void setDiagonalNumber(int diagonalNumber) {
        this.cell.setDiagonalNumber(diagonalNumber);
    }

    @Override
    public int getDiagonalNumber() {
        return this.cell.getDiagonalNumber();
    }

    @Override
    public void setDiagonalStyle(String diagonalStyle) {
        this.cell.setDiagonalStyle(diagonalStyle);
    }

    @Override
    public String getDiagonalStyle() {
        return this.cell.getDiagonalStyle();
    }

    @Override
    public void setDiagonalWidth(DimensionType diagonalWidth) {
        this.cell.setDiagonalWidth(diagonalWidth);
    }

    @Override
    public DimensionType getDiagonalWidth() {
        return this.cell.getDiagonalWidth();
    }

    @Override
    public void setDiagonalColor(String diagonalColor) {
        this.cell.setDiagonalColor(diagonalColor);
    }

    @Override
    public String getDiagonalColor() {
        return this.cell.getDiagonalColor();
    }

    @Override
    public void setAntidiagonalNumber(int antidiagonalNumber) {
        this.cell.setAntidiagonalNumber(antidiagonalNumber);
    }

    @Override
    public int getAntidiagonalNumber() {
        return this.cell.getAntidiagonalNumber();
    }

    @Override
    public void setAntidiagonalStyle(String antidiagonalStyle) {
        this.cell.setAntidiagonalStyle(antidiagonalStyle);
    }

    @Override
    public String getAntidiagonalStyle() {
        return this.cell.getAntidiagonalStyle();
    }

    @Override
    public void setAntidiagonalWidth(DimensionType antidiagonalWidth) {
        this.cell.setAntidiagonalWidth(antidiagonalWidth);
    }

    @Override
    public DimensionType getAntidiagonalWidth() {
        return this.cell.getAntidiagonalWidth();
    }

    @Override
    public void setAntidiagonalColor(String antidiagonalColor) {
        this.cell.setAntidiagonalColor(antidiagonalColor);
    }

    @Override
    public String getAntidiagonalColor() {
        return this.cell.getAntidiagonalColor();
    }

    @Override
    public String getHeaders() {
        return this.cell.getHeaders();
    }

    @Override
    public String getScope() {
        return this.cell.getScope();
    }

    @Override
    public void setHeaders(String headers) {
        this.cell.setHeaders(headers);
    }

    public String getDrop() {
        return this.cell.getScope();
    }

    @Override
    public void setScope(String scope) {
        this.cell.setScope(scope);
    }

    @Override
    public boolean repeatContent() {
        return this.cell.repeatContent();
    }

    @Override
    public void setRepeatContent(boolean repeatContent) {
        this.cell.setRepeatContent(repeatContent);
    }
}

