/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.ListHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportFigureUtilities;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SectionBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ListLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementNonResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ListFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.layout.ListLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ListEditPart
extends ReportElementEditPart {
    private static final String GUIDEHANDLE_TEXT = Messages.getString((String)"ListEditPart.GUIDEHANDLE_TEXT");

    public ListEditPart(Object obj) {
        super(obj);
    }

    @Override
    protected AbstractGuideHandle createGuideHandle() {
        TableGuideHandle handle = new TableGuideHandle((GraphicalEditPart)this);
        handle.setIndicatorLabel(this.getGuideLabel());
        INodeProvider provider = ProviderFactory.createProvider(this.getModel());
        handle.setIndicatorIcon(provider.getNodeIcon(this.getModel()));
        handle.setToolTip((IFigure)ReportFigureUtilities.createToolTipFigure(provider.getNodeTooltip(this.getModel()), "ltr", "left"));
        return handle;
    }

    @Override
    public String getGuideLabel() {
        return GUIDEHANDLE_TEXT;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ListLayoutEditPolicy());
    }

    @Override
    public void refreshFigure() {
        this.refreshBorder(this.getListHandleAdapt().getHandle(), (BaseBorder)this.getFigure().getBorder());
        ((ListFigure)this.getFigure()).setRecommendSize(this.getListHandleAdapt().getSize());
        ((SectionBorder)this.getFigure().getBorder()).setPaddingInsets(this.getListHandleAdapt().getPadding(this.getFigure().getInsets()));
        this.refreshMargin();
        this.refreshBackground((DesignElementHandle)this.getModel());
        ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), this.getConstraint());
        this.markDirty();
    }

    @Override
    public void notifyModelChange() {
        super.notifyModelChange();
        this.markDirty();
    }

    private void markDirty() {
        IFigure figure = this.getContentPane();
        if (figure instanceof ListFigure) {
            ((ListFigure)figure).markDirtyTree(true);
        }
    }

    @Override
    public void refreshChildren() {
        super.refreshChildren();
        List list = this.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ((ListBandEditPart)list.get(i)).refreshChildren();
            ++i;
        }
    }

    protected IFigure createFigure() {
        ListFigure figure = new ListFigure();
        figure.setOpaque(false);
        return figure;
    }

    protected List getModelChildren() {
        return this.getListHandleAdapt().getChildren();
    }

    private ListHandleAdapter getListHandleAdapt() {
        return (ListHandleAdapter)this.getModelAdapter();
    }

    public boolean insertGroup() {
        return UIUtil.createGroup(this.getListHandleAdapt().getHandle());
    }

    public boolean insertGroup(int position) {
        return UIUtil.createGroup(this.getListHandleAdapt().getHandle(), position);
    }

    public void removeGroup(Object group) {
        try {
            this.getListHandleAdapt().removeGroup(group);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void includeSlotHandle(boolean bool, int id) {
        Object model = this.getListHandleAdapt().getChild(id);
        ListBandEditPart part = (ListBandEditPart)this.getViewer().getEditPartRegistry().get(model);
        if (part == null) {
            return;
        }
        part.setRenderVisile(bool);
    }

    public boolean isIncludeSlotHandle(int id) {
        Object model = this.getListHandleAdapt().getChild(id);
        ListBandEditPart part = (ListBandEditPart)this.getViewer().getEditPartRegistry().get(model);
        if (part == null) {
            return false;
        }
        return part.isRenderVisile();
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive() && request.getType() == "selection") {
            if (this.isFigureLeft(request)) {
                this.getViewer().setCursor(ReportPlugin.getDefault().getLeftCellCursor());
            } else {
                this.getViewer().setCursor(ReportPlugin.getDefault().getRightCellCursor());
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    protected void addChildVisual(EditPart part, int index) {
        this.getViewer().setCursor(null);
        super.addChildVisual(part, index);
    }

    @Override
    public boolean isinterest(Object model) {
        if (model instanceof ListGroupHandle && this.getModelAdapter().isChildren((DesignElementHandle)model)) {
            return true;
        }
        return super.isinterest(model);
    }

    @Override
    protected void contentChange(Map info) {
        int intValue;
        Object action = info.get("Content event type");
        if (action instanceof Integer && (intValue = ((Integer)action).intValue()) == 2) {
            List list = (List)info.get("Event contents");
            int size = list.size();
            int i = 0;
            while (i < size) {
                Object obj = list.get(i);
                if (obj instanceof DesignElementHandle) {
                    this.getListHandleAdapt().remove(obj);
                }
                ++i;
            }
        }
        super.contentChange(info);
    }

    @Override
    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        return new ReportElementNonResizablePolicy();
    }

    protected Object getConstraint() {
        ReportItemHandle handle = (ReportItemHandle)this.getModel();
        ReportItemConstraint constraint = new ReportItemConstraint();
        DimensionHandle value = handle.getWidth();
        constraint.setMeasure(value.getMeasure());
        constraint.setUnits(value.getUnits());
        constraint.setFitTable(true);
        return constraint;
    }

    @Override
    protected void updateLayoutPreference() {
        super.updateLayoutPreference();
        if (!(((DesignElementHandle)this.getModel()).getModuleHandle() instanceof ReportDesignHandle)) {
            return;
        }
        ReportDesignHandle handle = (ReportDesignHandle)((DesignElementHandle)this.getModel()).getModuleHandle();
        String str = handle.getLayoutPreference();
        ((ListLayout)this.getContentPane().getLayoutManager()).setLayoutPreference(str);
    }
}

