/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskArray;

public class BufferedPrimitiveDiskArray
implements IDiskArray {
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private PrimitiveDiskArray delegate = null;
    private Object[] buffer = null;
    private int bufferUsedSize = 0;
    private static Logger logger = Logger.getLogger(BufferedPrimitiveDiskArray.class.getName());

    public BufferedPrimitiveDiskArray() {
        this(Constants.LIST_BUFFER_SIZE);
    }

    public BufferedPrimitiveDiskArray(int bufferSize) {
        this.buffer = bufferSize <= 0 ? new Object[100] : new Object[bufferSize];
    }

    @Override
    public boolean add(Object o) throws IOException {
        if (this.bufferUsedSize < this.buffer.length) {
            this.buffer[this.bufferUsedSize] = o;
            ++this.bufferUsedSize;
            return true;
        }
        if (this.delegate == null) {
            this.delegate = new PrimitiveDiskArray();
        }
        this.delegate.add(o);
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.clearDiskFile();
        this.buffer = null;
    }

    private void clearDiskFile() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }

    @Override
    public Object get(int index) throws IOException {
        if (index < this.bufferUsedSize) {
            return this.buffer[index];
        }
        if (this.delegate == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return this.delegate.get(index - this.buffer.length);
    }

    @Override
    public int size() {
        if (this.delegate == null) {
            return this.bufferUsedSize;
        }
        return this.buffer.length + this.delegate.size();
    }

    @Override
    public void clear() throws IOException {
        this.bufferUsedSize = 0;
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }
}

