/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationRowAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.SetUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.AggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.ICubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.InvalidCubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.ValidCubePosFilter;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.NEvaluator;

public class AggrMeasureFilterHelper {
    protected Map dimMap = new HashMap();
    protected IAggregationResultSet[] resultSet;
    private CubeQueryExecutor executor;
    protected IBindingValueFetcher fetcher;

    public AggrMeasureFilterHelper(ICube cube, IAggregationResultSet[] resultSet) {
        IDimension[] dimension = cube.getDimesions();
        int i = 0;
        while (i < dimension.length) {
            this.dimMap.put(dimension[i].getName(), dimension[i]);
            ++i;
        }
        this.resultSet = resultSet;
    }

    protected List<String> getAggregationName() {
        ArrayList<String> aggregationName = new ArrayList<String>();
        int i = 0;
        while (i < this.resultSet.length) {
            AggregationFunctionDefinition[] functions = this.resultSet[i].getAggregationDefinition().getAggregationFunctions();
            if (functions != null) {
                int j = 0;
                while (j < functions.length) {
                    aggregationName.add(functions[j].getName());
                    ++j;
                }
            }
            ++i;
        }
        return aggregationName;
    }

    public void setQueryExecutor(CubeQueryExecutor executor) {
        this.executor = executor;
    }

    public void setBindingValueFetcher(IBindingValueFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public List getCubePosFilters(List jsMeasureEvalFilterHelper) throws DataException, IOException {
        String[] aggregationNames = this.populateAggregationNames(this.getAggregationName(), jsMeasureEvalFilterHelper);
        ArrayList<ICubePosFilter> cubePosFilterList = new ArrayList<ICubePosFilter>();
        int i = 0;
        while (i < this.resultSet.length) {
            if (this.hasDefinition(this.resultSet[i], aggregationNames)) {
                if (this.resultSet[i].getAllLevels() == null || this.resultSet[i].getAllLevels().length == 0) {
                    if (this.resultSet[i].length() == 0) {
                        return null;
                    }
                    AggregationRowAccessor rowAccessor = new AggregationRowAccessor(this.resultSet[i], this.fetcher);
                    int j = 0;
                    while (j < jsMeasureEvalFilterHelper.size()) {
                        IAggrMeasureFilterEvalHelper filterHelper;
                        if (this.resultSet[i].getAggregationIndex(aggregationNames[j]) >= 0 && !this.isTopBottomNConditionalExpression((filterHelper = (IAggrMeasureFilterEvalHelper)jsMeasureEvalFilterHelper.get(j)).getExpression()) && !filterHelper.evaluateFilter(rowAccessor)) {
                            return null;
                        }
                        ++j;
                    }
                } else {
                    Map levelMap = this.populateLevelMap(this.resultSet[i]);
                    int dimSize = levelMap.size();
                    List[] levelListArray = new List[dimSize];
                    levelMap.values().toArray(levelListArray);
                    String[] dimensionNames = new String[dimSize];
                    levelMap.keySet().toArray(dimensionNames);
                    IDiskArray rowIndexArray = this.collectValidRowIndexArray(this.resultSet[i], jsMeasureEvalFilterHelper, aggregationNames);
                    ICubePosFilter cubePosFilter = null;
                    cubePosFilter = rowIndexArray.size() <= this.resultSet[i].length() / 2 ? this.getValidPosFilter(this.resultSet[i], rowIndexArray, dimensionNames, levelListArray) : this.getInvalidPosFilter(this.resultSet[i], rowIndexArray, dimensionNames, levelListArray);
                    cubePosFilterList.add(cubePosFilter);
                }
            }
            ++i;
        }
        return cubePosFilterList;
    }

    protected boolean hasDefinition(IAggregationResultSet resultSet, String[] aggregationNames) throws IOException {
        int j = 0;
        while (j < aggregationNames.length) {
            if (resultSet.getAggregationIndex(aggregationNames[j]) >= 0 && resultSet.getAggregationDefinition().getDrilledInfo() == null) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private IBinding getBinding(String bindingName, List bindings) throws DataException {
        int j = 0;
        while (j < bindings.size()) {
            IBinding binding = (IBinding)bindings.get(j);
            if (bindingName.equals(binding.getBindingName())) {
                return binding;
            }
            ++j;
        }
        return null;
    }

    protected String[] populateAggregationNames(List<String> allAggrNames, List jsMeasureEvalFilterHelper) throws DataException {
        String[] aggregationNames = new String[jsMeasureEvalFilterHelper.size()];
        int i = 0;
        while (i < aggregationNames.length) {
            IAggrMeasureFilterEvalHelper filterHelper = (IAggrMeasureFilterEvalHelper)jsMeasureEvalFilterHelper.get(i);
            List<String> bindingName = ExpressionCompilerUtil.extractColumnExpression(filterHelper.getExpression(), "data");
            aggregationNames[i] = (String)this.getIntersection(allAggrNames, bindingName);
            if (aggregationNames[i] == null) {
                aggregationNames[i] = OlapExpressionCompiler.getReferencedScriptObject(filterHelper.getExpression(), "row");
                if (aggregationNames[i] == null && this.executor != null) {
                    ArrayList<IBinding> bindingList = new ArrayList<IBinding>();
                    ICubeQueryDefinition query = this.executor.getCubeQueryDefinition();
                    bindingList.addAll(query.getBindings());
                    if (query instanceof PreparedCubeQueryDefinition) {
                        bindingList.addAll(((PreparedCubeQueryDefinition)query).getBindingsForNestAggregation());
                    }
                    ArrayList<String> referencedNames = new ArrayList<String>();
                    int j = 0;
                    while (j < bindingName.size()) {
                        IBinding b = this.getBinding(bindingName.get(j).toString(), bindingList);
                        if (b != null && b.getAggregatOns().size() == 0 && b.getAggrFunction() == null) {
                            referencedNames.addAll(ExpressionCompilerUtil.extractColumnExpression(b.getExpression(), "data"));
                        }
                        ++j;
                    }
                    aggregationNames[i] = (String)this.getIntersection(allAggrNames, referencedNames);
                }
            }
            ++i;
        }
        return aggregationNames;
    }

    private Object getIntersection(List list1, List list2) {
        int i = 0;
        while (i < list1.size()) {
            int j = 0;
            while (j < list2.size()) {
                if (list1.get(i).equals(list2.get(j))) {
                    return list1.get(i);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected ICubePosFilter getInvalidPosFilter(IAggregationResultSet resultSet, IDiskArray rowIndexArray, String[] dimensionNames, List[] levelListArray) throws IOException, DataException {
        InvalidCubePosFilter cubePosFilter = new InvalidCubePosFilter(dimensionNames);
        int rowIndex = 0;
        int i = 0;
        while (i < resultSet.length()) {
            Integer index;
            if (rowIndex < rowIndexArray.size() && i == (index = (Integer)rowIndexArray.get(rowIndex))) {
                ++rowIndex;
            } else {
                resultSet.seek(i);
                IDiskArray[] dimPositions = new IDiskArray[dimensionNames.length];
                int j = 0;
                while (j < levelListArray.length) {
                    int k = 0;
                    while (k < levelListArray[j].size()) {
                        DimLevel level = (DimLevel)levelListArray[j].get(k);
                        int levelIndex = resultSet.getLevelIndex(level);
                        Object[] value = resultSet.getLevelKeyValue(levelIndex);
                        IDiskArray positions = this.find(dimensionNames[j], level, value);
                        dimPositions[j] = dimPositions[j] == null ? positions : SetUtil.getIntersection(dimPositions[j], positions);
                        ++k;
                    }
                    ++j;
                }
                cubePosFilter.addDimPositions(dimPositions);
                int n = 0;
                while (n < dimPositions.length) {
                    dimPositions[n].close();
                    ++n;
                }
            }
            ++i;
        }
        return cubePosFilter;
    }

    protected ICubePosFilter getValidPosFilter(IAggregationResultSet resultSet, IDiskArray rowIndexArray, String[] dimensionNames, List[] levelListArray) throws IOException, DataException {
        ValidCubePosFilter cubePosFilter = new ValidCubePosFilter(dimensionNames);
        int i = 0;
        while (i < rowIndexArray.size()) {
            Integer rowIndex = (Integer)rowIndexArray.get(i);
            resultSet.seek(rowIndex);
            IDiskArray[] dimPositions = new IDiskArray[dimensionNames.length];
            int j = 0;
            while (j < levelListArray.length) {
                int k = 0;
                while (k < levelListArray[j].size()) {
                    DimLevel level = (DimLevel)levelListArray[j].get(k);
                    int levelIndex = resultSet.getLevelIndex(level);
                    Object[] value = resultSet.getLevelKeyValue(levelIndex);
                    IDiskArray positions = this.find(dimensionNames[j], level, value);
                    dimPositions[j] = dimPositions[j] == null ? positions : SetUtil.getIntersection(dimPositions[j], positions);
                    ++k;
                }
                ++j;
            }
            cubePosFilter.addDimPositions(dimPositions);
            int n = 0;
            while (n < dimPositions.length) {
                dimPositions[n].close();
                ++n;
            }
            ++i;
        }
        return cubePosFilter;
    }

    private IDiskArray collectValidRowIndexArray(IAggregationResultSet resultSet, List filterHelpers, String[] aggregationNames) throws DataException, IOException {
        int i;
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray();
        AggregationRowAccessor rowAccessor = new AggregationRowAccessor(resultSet, this.fetcher);
        ArrayList<IAggrMeasureFilterEvalHelper> firstRoundFilterHelper = new ArrayList<IAggrMeasureFilterEvalHelper>();
        FilterPassController filterPassController = new FilterPassController();
        int j = 0;
        while (j < filterHelpers.size()) {
            IAggrMeasureFilterEvalHelper filterHelper;
            if (resultSet.getAggregationIndex(aggregationNames[j]) >= 0 && this.isTopBottomNConditionalExpression((filterHelper = (IAggrMeasureFilterEvalHelper)filterHelpers.get(j)).getExpression())) {
                IConditionalExpression expr = (IConditionalExpression)filterHelper.getExpression();
                firstRoundFilterHelper.add(filterHelper);
                expr.setHandle(NEvaluator.newInstance(PropertySecurity.getSystemProperty("java.io.tmpdir"), expr.getOperator(), expr.getExpression(), (IScriptExpression)expr.getOperand1(), filterPassController));
            }
            ++j;
        }
        filterPassController.setPassLevel(1);
        filterPassController.setRowCount(resultSet.length());
        if (firstRoundFilterHelper.size() > 0) {
            i = 0;
            while (i < resultSet.length()) {
                resultSet.seek(i);
                int j2 = 0;
                while (j2 < firstRoundFilterHelper.size()) {
                    ((IAggrMeasureFilterEvalHelper)firstRoundFilterHelper.get(j2)).evaluateFilter(rowAccessor);
                    ++j2;
                }
                ++i;
            }
        }
        filterPassController.setPassLevel(2);
        i = 0;
        while (i < resultSet.length()) {
            resultSet.seek(i);
            boolean isFilterByAll = true;
            int j3 = 0;
            while (j3 < filterHelpers.size()) {
                IAggrMeasureFilterEvalHelper filterHelper;
                if (resultSet.getAggregationIndex(aggregationNames[j3]) >= 0 && !(filterHelper = (IAggrMeasureFilterEvalHelper)filterHelpers.get(j3)).evaluateFilter(rowAccessor)) {
                    isFilterByAll = false;
                    break;
                }
                ++j3;
            }
            if (isFilterByAll) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public IAggregationResultSet[] removeInvalidAggrRows(List jsMeasureEvalFilterHelper, List<Integer> affectedAggrResultSetIndex) throws DataException, IOException {
        IAggregationResultSet[] result = new IAggregationResultSet[this.resultSet.length];
        String[] aggregationNames = this.populateAggregationNames(this.getAggregationName(), jsMeasureEvalFilterHelper);
        int i = 0;
        while (i < this.resultSet.length) {
            if (this.hasDefinition(this.resultSet[i], aggregationNames)) {
                IDiskArray validRows = this.collectValidAggregationResultSetRows(this.resultSet[i], jsMeasureEvalFilterHelper, aggregationNames);
                AggregationResultSet newAggrResultSet = new AggregationResultSet(this.resultSet[i].getAggregationDefinition(), this.resultSet[i].getAllLevels(), validRows, this.resultSet[i].getKeyNames(), this.resultSet[i].getAttributeNames());
                result[i] = newAggrResultSet;
                affectedAggrResultSetIndex.add(i);
            } else {
                result[i] = this.resultSet[i];
            }
            ++i;
        }
        return result;
    }

    private IDiskArray collectValidAggregationResultSetRows(IAggregationResultSet resultSet, List filterHelpers, String[] aggregationNames) throws DataException, IOException {
        int i;
        BufferedStructureArray result = new BufferedStructureArray(AggregationResultRow.getCreator(), resultSet.length());
        AggregationRowAccessor rowAccessor = new AggregationRowAccessor(resultSet, this.fetcher);
        ArrayList<IAggrMeasureFilterEvalHelper> firstRoundFilterHelper = new ArrayList<IAggrMeasureFilterEvalHelper>();
        FilterPassController filterPassController = new FilterPassController();
        int j = 0;
        while (j < filterHelpers.size()) {
            IAggrMeasureFilterEvalHelper filterHelper;
            if (resultSet.getAggregationIndex(aggregationNames[j]) >= 0 && this.isTopBottomNConditionalExpression((filterHelper = (IAggrMeasureFilterEvalHelper)filterHelpers.get(j)).getExpression())) {
                IConditionalExpression expr = (IConditionalExpression)filterHelper.getExpression();
                firstRoundFilterHelper.add(filterHelper);
                expr.setHandle(NEvaluator.newInstance(PropertySecurity.getSystemProperty("java.io.tmpdir"), expr.getOperator(), expr.getExpression(), (IScriptExpression)expr.getOperand1(), filterPassController));
            }
            ++j;
        }
        filterPassController.setPassLevel(1);
        filterPassController.setRowCount(resultSet.length());
        if (firstRoundFilterHelper.size() > 0) {
            i = 0;
            while (i < resultSet.length()) {
                resultSet.seek(i);
                int j2 = 0;
                while (j2 < firstRoundFilterHelper.size()) {
                    ((IAggrMeasureFilterEvalHelper)firstRoundFilterHelper.get(j2)).evaluateFilter(rowAccessor);
                    ++j2;
                }
                ++i;
            }
        }
        filterPassController.setPassLevel(2);
        i = 0;
        while (i < resultSet.length()) {
            resultSet.seek(i);
            boolean isFilterByAll = true;
            int j3 = 0;
            while (j3 < filterHelpers.size()) {
                AggrMeasureFilterEvalHelper filterHelper;
                if (resultSet.getAggregationIndex(aggregationNames[j3]) >= 0 && !(filterHelper = (AggrMeasureFilterEvalHelper)filterHelpers.get(j3)).evaluateFilter(rowAccessor)) {
                    isFilterByAll = false;
                    break;
                }
                ++j3;
            }
            if (isFilterByAll) {
                result.add(resultSet.getCurrentRow());
            }
            ++i;
        }
        return result;
    }

    protected boolean isTopBottomNConditionalExpression(IBaseExpression expr) {
        if (expr == null || !(expr instanceof IConditionalExpression)) {
            return false;
        }
        switch (((IConditionalExpression)expr).getOperator()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    protected Map populateLevelMap(IAggregationResultSet resultSet) {
        DimLevel[] dimLevels = resultSet.getAllLevels();
        HashMap<String, ArrayList<DimLevel>> levelMap = new HashMap<String, ArrayList<DimLevel>>();
        int j = 0;
        while (j < dimLevels.length) {
            String dimensionName = dimLevels[j].getDimensionName();
            ArrayList<DimLevel> list = (ArrayList<DimLevel>)levelMap.get(dimensionName);
            if (list == null) {
                list = new ArrayList<DimLevel>();
                levelMap.put(dimensionName, list);
            }
            list.add(dimLevels[j]);
            ++j;
        }
        return levelMap;
    }

    private IDiskArray find(String dimensionName, DimLevel level, Object[] keyValue) throws DataException, IOException {
        Dimension dimension = (Dimension)this.dimMap.get(dimensionName);
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int i = 0;
        while (i < levels.length) {
            if (level.getLevelName().equals(levels[i].getName())) break;
            ++i;
        }
        if (i < levels.length) {
            return dimension.findPosition((Level)levels[i], keyValue);
        }
        throw new DataException("Can't find level {0} in the dimension!", level);
    }
}

