/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.ExcelDataSourcePageHelper;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.IChangeListener;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.NewDataSourceWizardBase;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ExcelDataSourceWizardPage
extends DataSourceWizardPage {
    private ExcelDataSourcePageHelper pageHelper;
    private Properties folderProperties;
    private NewDataSourceWizardBase odaWizard;
    private Shell shell;
    private List<IChangeListener> pageStatusChangedListeners = new ArrayList<IChangeListener>();

    public ExcelDataSourceWizardPage(String pageName) {
        super(pageName);
        this.setMessage(ExcelDataSourcePageHelper.DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        if (this.pageHelper == null) {
            this.pageHelper = new ExcelDataSourcePageHelper(this);
        }
        this.pageHelper.setResourceIdentifiers(this.getHostResourceIdentifiers());
        this.pageHelper.createCustomControl(parent);
        this.pageHelper.initCustomControl(this.folderProperties);
    }

    protected NewDataSourceWizardBase getOdaWizard() {
        return this.odaWizard;
    }

    public void setWizard(IWizard newWizard) {
        if (newWizard instanceof NewDataSourceWizardBase) {
            this.odaWizard = (NewDataSourceWizardBase)newWizard;
        }
        super.setWizard(newWizard);
    }

    public IWizard getWizard() {
        return this.getOdaWizard();
    }

    public Properties collectCustomProperties() {
        if (this.pageHelper != null) {
            return this.pageHelper.collectCustomProperties(this.folderProperties);
        }
        return this.folderProperties != null ? this.folderProperties : new Properties();
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.folderProperties = dataSourceProps;
        if (this.pageHelper == null) {
            return;
        }
        this.pageHelper.initCustomControl(this.folderProperties);
    }

    public void refresh() {
        this.enableAllControls(this.getControl(), this.isSessionEditable());
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        return this.pageHelper.createTestConnectionRunnable(profile);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        super.createControl(parent);
    }

    public Shell getShell() {
        Shell shell = super.getShell();
        if (shell == null) {
            return this.shell;
        }
        return shell;
    }

    public void addPageChangedListener(IChangeListener listener) {
        if (listener != null && !this.pageStatusChangedListeners.contains(listener)) {
            this.pageStatusChangedListeners.add(listener);
        }
    }

    public void removePageChangedListener(IChangeListener listener) {
        this.pageStatusChangedListeners.remove(listener);
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        int i = 0;
        while (i < this.pageStatusChangedListeners.size()) {
            this.pageStatusChangedListeners.get(i).update(true);
            ++i;
        }
    }

    protected ResourceIdentifiers getHostResourceIdentifiers() {
        ResourceIdentifiers designResourceIds = super.getHostResourceIdentifiers();
        if (designResourceIds == null) {
            designResourceIds = DesignFactory.eINSTANCE.createResourceIdentifiers();
            designResourceIds.setApplResourceBaseURI(DTPUtil.getInstance().getBIRTResourcePath());
            designResourceIds.setDesignResourceBaseURI(DTPUtil.getInstance().getReportDesignPath());
        }
        return designResourceIds;
    }
}

