/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.CommandLineQuoting;
import org.eclipse.jdt.internal.launching.IProcessTempFileCreator;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;

public class CommandLineShortener
implements IProcessTempFileCreator {
    private final String javaVersion;
    private final ILaunch launch;
    private final String[] cmdLine;
    private File processTempFilesDir;
    private final List<File> processTempFiles = new ArrayList<File>();

    public static String getJavaVersion(IVMInstall vmInstall) {
        if (vmInstall instanceof IVMInstall2) {
            IVMInstall2 install = (IVMInstall2)((Object)vmInstall);
            return install.getJavaVersion();
        }
        return null;
    }

    public CommandLineShortener(IVMInstall vmInstall, ILaunch launch, String[] cmdLine, File workingDir) {
        this(CommandLineShortener.getJavaVersion(vmInstall), launch, cmdLine, workingDir);
    }

    protected CommandLineShortener(String javaVersion, ILaunch launch, String[] cmdLine, File workingDir) {
        Assert.isNotNull((Object)javaVersion);
        Assert.isNotNull((Object)launch);
        Assert.isNotNull((Object)cmdLine);
        this.javaVersion = javaVersion;
        this.launch = launch;
        this.cmdLine = cmdLine;
        this.processTempFilesDir = workingDir != null ? workingDir : Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile();
    }

    protected void addProcessTempFile(File file) {
        this.processTempFiles.add(file);
    }

    /*
     * Unable to fully structure code
     */
    protected File createArgumentFile(String[] cmdLine) throws CoreException {
        systemCharset = Platform.getSystemCharset();
        try {
            timeStamp = this.getLaunchTimeStamp();
            argumentsFile = new File(this.processTempFilesDir, String.format(".temp-%s-args-%s.txt", new Object[]{this.getLaunchConfigurationName(), timeStamp}));
            cmdLine = this.quoteForArgfile(cmdLine);
            Files.write(argumentsFile.toPath(), Arrays.asList(cmdLine), systemCharset, new OpenOption[0]);
            return argumentsFile;
        }
        catch (CharacterCodingException e) {
            var7_8 = cmdLine;
            var6_9 = cmdLine.length;
            var5_10 = 0;
            ** while (var5_10 < var6_9)
        }
lbl-1000:
        // 1 sources

        {
            s = var7_8[var5_10];
            var11_14 = s.toCharArray();
            var10_13 = var11_14.length;
            var9_12 = 0;
            while (var9_12 < var10_13) {
                c = var11_14[var9_12];
                if (!systemCharset.newEncoder().canEncode(c)) {
                    throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot encode argument as file: Illegal character " + String.format("\\u%04x", new Object[]{(int)c}) + " for system charset " + systemCharset.displayName() + ".", (Throwable)e));
                }
                ++var9_12;
            }
            ++var5_10;
            continue;
        }
lbl26:
        // 1 sources

        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot encode argument as file", (Throwable)e));
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot create argument file", (Throwable)e));
        }
    }

    String[] quoteForArgfile(String[] cmdLine) {
        String[] quotedCmdLine = new String[cmdLine.length];
        int i = 0;
        while (i < cmdLine.length) {
            String arg = cmdLine[i];
            if (CommandLineQuoting.needsQuoting(arg)) {
                StringBuilder escapedArg = new StringBuilder();
                int j = 0;
                while (j < arg.length()) {
                    char c = arg.charAt(j);
                    if (c == '\\') {
                        escapedArg.append('\\');
                    } else if (c == '\"') {
                        escapedArg.append('\\');
                    }
                    escapedArg.append(c);
                    ++j;
                }
                arg = "\"" + escapedArg.toString() + "\"";
            }
            quotedCmdLine[i] = arg;
            ++i;
        }
        return quotedCmdLine;
    }

    protected String getLaunchConfigurationName() {
        return this.launch.getLaunchConfiguration().getName();
    }

    protected String getLaunchTimeStamp() {
        String timeStamp = this.launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        if (timeStamp == null) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        return timeStamp;
    }

    @Override
    public List<File> getProcessTempFiles() {
        return new ArrayList<File>(this.processTempFiles);
    }

    public File getProcessTempFilesDir() {
        return this.processTempFilesDir;
    }

    public String[] getOriginalCmdLine() {
        return this.cmdLine;
    }

    protected boolean isArgumentFileSupported() {
        return JavaCore.compareJavaVersions((String)this.javaVersion, (String)"9") >= 0;
    }

    public void setProcessTempFilesDir(File processTempFilesDir) {
        this.processTempFilesDir = processTempFilesDir;
    }

    public String[] shortenCommandLine() throws CoreException {
        ArrayList<String> fullCommandLine = new ArrayList<String>(Arrays.asList(this.cmdLine));
        ArrayList<String> shortCommandLine = new ArrayList<String>();
        shortCommandLine.add((String)fullCommandLine.remove(0));
        File argumentFile = this.createArgumentFile(fullCommandLine.toArray(new String[fullCommandLine.size()]));
        this.addProcessTempFile(argumentFile);
        shortCommandLine.add("@" + argumentFile.getAbsolutePath());
        return shortCommandLine.toArray(new String[shortCommandLine.size()]);
    }

    public boolean shouldShortenCommandLine() throws CoreException {
        if (!this.isArgumentFileSupported()) {
            return false;
        }
        if (this.cmdLine.length < 2) {
            return false;
        }
        ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
        if (configuration != null) {
            return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, false);
        }
        return false;
    }
}

