/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import java.util.Properties;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MongoDBDataSourcePageHelper {
    private static final String EMPTY_STRING = "";
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private Button URIElementsRadioBtn;
    private Button URIRadioBtn;
    private Button socketAliveCheckbox;
    private Button useKerberosAuthenticationCheckBox;
    private Button kerberosConfigurationRadioBtn;
    private Button kerberosCredentialsRadioBtn;
    private Group URIElementsGroup;
    private Group kerberosConfigElementGroup;
    private Text serverHostText;
    private Text serverPortText;
    private Text databaseNameText;
    private Text userNameText;
    private Text passwordText;
    private Text databaseURIText;
    private Text gssapiServiceNameText;
    private Text kerberosConfigurationFileText;
    private Text gssAPIConfigurationFileText;
    private Text kerberosPrincipalText;
    private Text kerberosPasswordText;
    private boolean isPropertyPage;
    private boolean isURITextFieldFoucs;
    private boolean socketAlive;
    private boolean useKerberosAuthentication;
    private boolean isKerberosPasswordFieldFoucs;
    private String dbURI;
    private String serverHost;
    private String serverPort;
    private String dbName;
    private String userName;
    private String password;
    private String gssapiServiceName;
    private String kerberosConfigurationFile;
    private String gssAPIConfigurationFile;
    private String kerberosPrincipal;
    private String kerberosPassword;
    private String DEFAULT_MESSAGE = Messages.getString("MongoDBDataSourceWizardPage.message.default");

    public MongoDBDataSourcePageHelper(WizardPage page) {
        this.wizardPage = page;
        this.isPropertyPage = false;
    }

    public MongoDBDataSourcePageHelper(PreferencePage page) {
        this.propertyPage = page;
        this.isPropertyPage = true;
    }

    public Composite createPageControls(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createURIRadioButtonsArea(composite);
        this.createClientSettingsArea(composite);
        this.createKerberosSettingsArea(composite);
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinWidth(size.x + 250);
        scrolledComposite.setMinHeight(size.y + 20);
        scrolledComposite.setContent((Control)composite);
        return composite;
    }

    private void createClientSettingsArea(Composite composite) {
        Group settingsGroup = new Group(composite, 0);
        settingsGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.GroupTitle.SupplementalSetting"));
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData groupGridData = new GridData(768);
        settingsGroup.setLayoutData((Object)groupGridData);
        this.socketAliveCheckbox = new Button((Composite)settingsGroup, 32);
        this.socketAliveCheckbox.setText(Messages.getString("MongoDBDataSourceWizardPage.checkbox.label.SocketAlive"));
        this.socketAliveCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSourcePageHelper.this.socketAlive = MongoDBDataSourcePageHelper.this.socketAliveCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createKerberosSettingsArea(Composite composite) {
        Group kerberosSettingsGroup = new Group(composite, 0);
        kerberosSettingsGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.GroupTitle.KerberosSetting"));
        kerberosSettingsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData groupGridData = new GridData(768);
        kerberosSettingsGroup.setLayoutData((Object)groupGridData);
        Composite kerberosSettingComposite1 = new Composite((Composite)kerberosSettingsGroup, 0);
        kerberosSettingComposite1.setLayout((Layout)new GridLayout(1, false));
        kerberosSettingComposite1.setLayoutData((Object)new GridData(768));
        this.useKerberosAuthenticationCheckBox = new Button(kerberosSettingComposite1, 32);
        this.useKerberosAuthenticationCheckBox.setText(Messages.getString("MongoDBDataSourceWizardPage.checkbox.label.KerberosAuthentication"));
        this.useKerberosAuthenticationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSourcePageHelper.this.useKerberosAuthentication = MongoDBDataSourcePageHelper.this.useKerberosAuthenticationCheckBox.getSelection();
                MongoDBDataSourcePageHelper.this.handleKerberosAuthenticationSelection();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite kerberosSettingComposite2 = new Composite((Composite)kerberosSettingsGroup, 0);
        kerberosSettingComposite2.setLayout((Layout)new GridLayout(2, false));
        kerberosSettingComposite2.setLayoutData((Object)new GridData(768));
        Label kerberosPrincipalLabel = new Label(kerberosSettingComposite2, 0);
        kerberosPrincipalLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.KerberosPrincipal"));
        this.kerberosPrincipalText = new Text(kerberosSettingComposite2, 2048);
        this.kerberosPrincipalText.setLayoutData((Object)new GridData(768));
        this.kerberosPrincipalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.kerberosPrincipal = MongoDBDataSourcePageHelper.this.kerberosPrincipalText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label gssapiServiceNameLabel = new Label(kerberosSettingComposite2, 0);
        gssapiServiceNameLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.GssapiServiceName"));
        this.gssapiServiceNameText = new Text(kerberosSettingComposite2, 2048);
        this.gssapiServiceNameText.setLayoutData((Object)new GridData(768));
        this.gssapiServiceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.gssapiServiceName = MongoDBDataSourcePageHelper.this.gssapiServiceNameText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Composite kerberosSettingComposite3 = new Composite((Composite)kerberosSettingsGroup, 0);
        kerberosSettingComposite3.setLayout((Layout)new GridLayout(2, false));
        kerberosSettingComposite3.setLayoutData((Object)new GridData(768));
        this.kerberosConfigElementGroup = new Group(kerberosSettingComposite3, 0);
        this.kerberosConfigElementGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.RadioButton.label.KerberosConfiguration"));
        this.kerberosConfigElementGroup.setLayout((Layout)new GridLayout(2, false));
        GridData elementGroupGridData = new GridData(768);
        this.kerberosConfigElementGroup.setLayoutData((Object)elementGroupGridData);
        Label kerberosConfigurationFileLabel = new Label((Composite)this.kerberosConfigElementGroup, 0);
        kerberosConfigurationFileLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.KerberosConfigurationFile"));
        this.kerberosConfigurationFileText = new Text((Composite)this.kerberosConfigElementGroup, 2048);
        this.kerberosConfigurationFileText.setLayoutData((Object)new GridData(768));
        this.kerberosConfigurationFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.kerberosConfigurationFile = MongoDBDataSourcePageHelper.this.kerberosConfigurationFileText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label gssAPIConfigurationFileLabel = new Label((Composite)this.kerberosConfigElementGroup, 0);
        gssAPIConfigurationFileLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.GssAPIConfigurationFile"));
        this.gssAPIConfigurationFileText = new Text((Composite)this.kerberosConfigElementGroup, 2048);
        this.gssAPIConfigurationFileText.setLayoutData((Object)new GridData(768));
        this.gssAPIConfigurationFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.gssAPIConfigurationFile = MongoDBDataSourcePageHelper.this.gssAPIConfigurationFileText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
    }

    private void createURIRadioButtonsArea(Composite composite) {
        Composite URIComposite1 = new Composite(composite, 0);
        URIComposite1.setLayout((Layout)new GridLayout(2, false));
        URIComposite1.setLayoutData((Object)new GridData(768));
        this.URIElementsRadioBtn = new Button(URIComposite1, 16);
        GridData radioBtnData = new GridData();
        radioBtnData.verticalAlignment = 128;
        this.URIElementsRadioBtn.setLayoutData((Object)radioBtnData);
        this.URIElementsRadioBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSourcePageHelper.this.URIElementsRadioBtn.getSelection()) {
                    MongoDBDataSourcePageHelper.this.isURITextFieldFoucs = false;
                    MongoDBDataSourcePageHelper.this.handleRadioButtonSelection();
                    MongoDBDataSourcePageHelper.this.validatePageProperties();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.URIElementsGroup = new Group(URIComposite1, 0);
        this.URIElementsGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.GroupTitle.URIElements"));
        this.URIElementsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData groupGridData = new GridData(768);
        this.URIElementsGroup.setLayoutData((Object)groupGridData);
        Label serverHostLabel = new Label((Composite)this.URIElementsGroup, 0);
        serverHostLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.ServerHost"));
        this.serverHostText = new Text((Composite)this.URIElementsGroup, 2048);
        this.serverHostText.setLayoutData((Object)new GridData(768));
        this.serverHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.serverHost = MongoDBDataSourcePageHelper.this.serverHostText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label serverPortLabel = new Label((Composite)this.URIElementsGroup, 0);
        serverPortLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.ServerPort"));
        this.serverPortText = new Text((Composite)this.URIElementsGroup, 2048);
        this.serverPortText.setLayoutData((Object)new GridData(768));
        this.serverPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.serverPort = MongoDBDataSourcePageHelper.this.serverPortText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label databaseNameLabel = new Label((Composite)this.URIElementsGroup, 0);
        databaseNameLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.DatabaseName"));
        this.databaseNameText = new Text((Composite)this.URIElementsGroup, 2048);
        this.databaseNameText.setLayoutData((Object)new GridData(768));
        this.databaseNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.dbName = MongoDBDataSourcePageHelper.this.databaseNameText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label userNameLabel = new Label((Composite)this.URIElementsGroup, 0);
        userNameLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.UserName"));
        this.userNameText = new Text((Composite)this.URIElementsGroup, 2048);
        this.userNameText.setLayoutData((Object)new GridData(768));
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.userName = MongoDBDataSourcePageHelper.this.userNameText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label passwordLabel = new Label((Composite)this.URIElementsGroup, 0);
        passwordLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.Password"));
        this.passwordText = new Text((Composite)this.URIElementsGroup, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.password = MongoDBDataSourcePageHelper.this.passwordText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Composite URIComposite2 = new Composite(composite, 0);
        URIComposite2.setLayout((Layout)new GridLayout(2, false));
        URIComposite2.setLayoutData((Object)new GridData(768));
        this.URIRadioBtn = new Button(URIComposite2, 16);
        this.URIRadioBtn.setText(Messages.getString("MongoDBDataSourceWizardPage.RadioButton.label.DatabaseURI"));
        this.URIRadioBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSourcePageHelper.this.URIRadioBtn.getSelection()) {
                    MongoDBDataSourcePageHelper.this.isURITextFieldFoucs = true;
                    MongoDBDataSourcePageHelper.this.handleRadioButtonSelection();
                    MongoDBDataSourcePageHelper.this.dbURI = MongoDBDataSourcePageHelper.this.databaseURIText.getText().trim();
                    MongoDBDataSourcePageHelper.this.validatePageProperties();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.databaseURIText = new Text(URIComposite2, 2048);
        this.databaseURIText.setLayoutData((Object)new GridData(768));
        this.databaseURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.dbURI = MongoDBDataSourcePageHelper.this.databaseURIText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
    }

    protected void handleKerberosAuthenticationSelection() {
        if (this.kerberosPrincipalText != null && !this.kerberosPrincipalText.isDisposed()) {
            this.resetKerberosAuthenticationEditControlStatus();
        }
        if (this.kerberosPasswordText != null && !this.kerberosPasswordText.isDisposed()) {
            this.kerberosPrincipalText.setEnabled(this.useKerberosAuthentication);
            this.gssapiServiceNameText.setEnabled(this.useKerberosAuthentication);
            if (this.useKerberosAuthentication) {
                this.kerberosConfigurationRadioBtn.setEnabled(true);
                this.kerberosCredentialsRadioBtn.setEnabled(true);
                this.handleKerberosRadioButtonSelection();
            } else {
                this.disableKerberosConfigAndCredentialEditControl();
                this.kerberosConfigurationRadioBtn.setEnabled(false);
                this.kerberosCredentialsRadioBtn.setEnabled(false);
            }
        }
    }

    protected void resetKerberosAuthenticationEditControlStatus() {
        this.kerberosPrincipalText.setEnabled(this.useKerberosAuthentication);
        this.gssapiServiceNameText.setEnabled(this.useKerberosAuthentication);
        this.kerberosConfigurationFileText.setEnabled(this.useKerberosAuthentication);
        this.gssAPIConfigurationFileText.setEnabled(this.useKerberosAuthentication);
    }

    private void handleKerberosRadioButtonSelection() {
        this.kerberosConfigurationRadioBtn.setSelection(!this.isKerberosPasswordFieldFoucs);
    }

    private void disableKerberosConfigAndCredentialEditControl() {
        this.setKerberosConfigElementGroupEnabled(false);
    }

    private void setKerberosConfigElementGroupEnabled(boolean enabled) {
        this.kerberosConfigElementGroup.setEnabled(enabled);
        Control[] children = this.kerberosConfigElementGroup.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            ++i;
        }
    }

    private void handleRadioButtonSelection() {
        this.URIElementsRadioBtn.setSelection(!this.isURITextFieldFoucs);
        this.URIRadioBtn.setSelection(this.isURITextFieldFoucs);
        this.resetURIEditControlStatus();
    }

    protected void resetURIEditControlStatus() {
        if (this.databaseURIText != null && !this.databaseURIText.isDisposed()) {
            this.setURIElementsGroupEnabled(!this.isURITextFieldFoucs);
            this.databaseURIText.setEnabled(this.isURITextFieldFoucs);
        }
    }

    private void setURIElementsGroupEnabled(boolean enabled) {
        this.URIElementsGroup.setEnabled(enabled);
        Control[] children = this.URIElementsGroup.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            ++i;
        }
    }

    protected void initPageInfos(Properties dataSourceProps) {
        boolean ignoreURI;
        if (dataSourceProps == null) {
            return;
        }
        this.dbURI = dataSourceProps.getProperty(MongoDBDriver.MONGO_URI_PROP);
        this.serverHost = dataSourceProps.getProperty(MongoDBDriver.SERVER_HOST_PROP);
        this.serverPort = dataSourceProps.getProperty(MongoDBDriver.SERVER_PORT_PROP);
        if (this.serverPort == null || this.serverPort.trim().length() == 0) {
            this.serverPort = String.valueOf(MDbMetaData.defaultPort());
        }
        this.dbName = dataSourceProps.getProperty(MongoDBDriver.DBNAME_PROP);
        this.userName = dataSourceProps.getProperty(MongoDBDriver.USERNAME_PROP);
        this.password = dataSourceProps.getProperty(MongoDBDriver.PASSWORD_PROP);
        boolean bl = this.isURITextFieldFoucs = !UIHelper.isEmptyString(this.dbURI);
        if (this.isURITextFieldFoucs && (ignoreURI = Boolean.parseBoolean(dataSourceProps.getProperty(MongoDBDriver.IGNORE_URI_PROP)))) {
            this.isURITextFieldFoucs = false;
        }
        this.socketAlive = dataSourceProps.getProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP) != null ? Boolean.parseBoolean(dataSourceProps.getProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP)) : false;
        this.useKerberosAuthentication = Boolean.parseBoolean(dataSourceProps.getProperty(MongoDBDriver.USE_KERBEROS_PROP));
        this.kerberosPrincipal = dataSourceProps.getProperty(MongoDBDriver.KERBEROS_PRINCIPAL_PROP);
        this.gssapiServiceName = dataSourceProps.getProperty(MongoDBDriver.KERBEROS_GSSAPI_SERVICENAME_PROP);
        this.kerberosConfigurationFile = dataSourceProps.getProperty(MongoDBDriver.KERBEROS_KRB5CONFIG_FILE_PROP);
        this.gssAPIConfigurationFile = dataSourceProps.getProperty(MongoDBDriver.KERBEROS_GSS_JAAS_CONFIG_FILE_PROP);
        this.kerberosPassword = dataSourceProps.getProperty(MongoDBDriver.KERBEROS_PASSWORD_PROP);
        this.isKerberosPasswordFieldFoucs = !UIHelper.isEmptyString(this.kerberosPassword);
    }

    public void initPageControls(Properties dataSourceProps) {
        if (dataSourceProps == null) {
            return;
        }
        this.initPageInfos(dataSourceProps);
        this.refreshPageControls();
        this.validatePageProperties();
    }

    protected void refresh() {
        if (this.databaseURIText != null && !this.databaseURIText.isDisposed()) {
            this.refreshPageControls();
            this.validatePageProperties();
        }
    }

    protected void refreshPageControls() {
        this.databaseURIText.setText(this.dbURI == null ? EMPTY_STRING : this.dbURI);
        this.serverHostText.setText(this.serverHost == null ? EMPTY_STRING : this.serverHost);
        if (this.serverPort != null) {
            this.serverPortText.setText(this.serverPort);
        } else {
            this.serverPortText.setText(String.valueOf(MDbMetaData.defaultPort()));
        }
        this.databaseNameText.setText(this.dbName == null ? EMPTY_STRING : this.dbName);
        this.userNameText.setText(this.userName == null ? EMPTY_STRING : this.userName);
        this.passwordText.setText(this.password == null ? EMPTY_STRING : this.password);
        this.handleRadioButtonSelection();
        this.socketAliveCheckbox.setSelection(this.socketAlive);
        this.useKerberosAuthenticationCheckBox.setSelection(this.useKerberosAuthentication);
        this.kerberosPrincipalText.setText(this.kerberosPrincipal == null ? EMPTY_STRING : this.kerberosPrincipal);
        this.gssapiServiceNameText.setText(this.gssapiServiceName == null ? EMPTY_STRING : this.gssapiServiceName);
        this.kerberosConfigurationFileText.setText(this.kerberosConfigurationFile == null ? EMPTY_STRING : this.kerberosConfigurationFile);
        this.gssAPIConfigurationFileText.setText(this.gssAPIConfigurationFile == null ? EMPTY_STRING : this.gssAPIConfigurationFile);
        this.handleKerberosAuthenticationSelection();
        if (this.isURITextFieldFoucs) {
            this.databaseURIText.setFocus();
        } else {
            this.serverHostText.setFocus();
        }
    }

    private boolean validatePageProperties() {
        boolean isValid = true;
        if (this.URIRadioBtn.getSelection() || this.isURITextFieldFoucs) {
            if (this.databaseURIText.getText().trim().length() == 0) {
                isValid = false;
            }
        } else if (this.serverHostText.getText().trim().length() == 0 || this.serverPortText.getText().trim().length() == 0 || this.databaseNameText.getText().trim().length() == 0) {
            isValid = false;
        }
        if (isValid && this.useKerberosAuthentication) {
            if (this.kerberosPrincipalText.getText().trim().length() == 0) {
                isValid = false;
            } else if (this.gssAPIConfigurationFileText.getText().trim().length() == 0) {
                isValid = false;
            } else if (this.kerberosConfigurationFileText.getText().trim().length() == 0) {
                isValid = false;
            }
        }
        if (!isValid) {
            if (this.isPropertyPage) {
                this.propertyPage.setMessage(Messages.getString("MongoDBDataSourceWizardPage.error.MissingConnectionProperty"), 3);
            } else {
                this.wizardPage.setMessage(Messages.getString("MongoDBDataSourceWizardPage.error.MissingConnectionProperty"), 3);
            }
        } else if (this.isPropertyPage) {
            this.propertyPage.setMessage(this.DEFAULT_MESSAGE);
        } else {
            this.wizardPage.setMessage(this.DEFAULT_MESSAGE);
        }
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(isValid);
        }
        return isValid;
    }

    protected Properties collectCustomProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        if (this.serverHost != null) {
            properties.setProperty(MongoDBDriver.SERVER_HOST_PROP, this.serverHost);
        }
        if (this.serverPort != null) {
            properties.setProperty(MongoDBDriver.SERVER_PORT_PROP, this.serverPort);
        }
        if (this.dbName != null) {
            properties.setProperty(MongoDBDriver.DBNAME_PROP, this.dbName);
        }
        if (this.userName != null) {
            properties.setProperty(MongoDBDriver.USERNAME_PROP, this.userName);
        }
        if (this.password != null) {
            properties.setProperty(MongoDBDriver.PASSWORD_PROP, this.password);
        }
        if (this.dbURI != null) {
            properties.setProperty(MongoDBDriver.MONGO_URI_PROP, this.dbURI);
        }
        properties.setProperty(MongoDBDriver.IGNORE_URI_PROP, Boolean.toString(this.URIElementsRadioBtn.getSelection() || UIHelper.isEmptyString(this.dbURI)));
        properties.setProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP, String.valueOf(this.socketAlive));
        properties.setProperty(MongoDBDriver.USE_KERBEROS_PROP, Boolean.toString(this.useKerberosAuthentication));
        if (this.kerberosPrincipal != null) {
            properties.setProperty(MongoDBDriver.KERBEROS_PRINCIPAL_PROP, this.kerberosPrincipal);
        }
        if (this.gssapiServiceName != null) {
            properties.setProperty(MongoDBDriver.KERBEROS_GSSAPI_SERVICENAME_PROP, this.gssapiServiceName);
        }
        if (this.kerberosConfigurationFile != null) {
            properties.setProperty(MongoDBDriver.KERBEROS_KRB5CONFIG_FILE_PROP, this.kerberosConfigurationFile);
        }
        if (this.gssAPIConfigurationFile != null) {
            properties.setProperty(MongoDBDriver.KERBEROS_GSS_JAAS_CONFIG_FILE_PROP, this.gssAPIConfigurationFile);
        }
        if (this.kerberosPassword != null) {
            properties.setProperty(MongoDBDriver.KERBEROS_PASSWORD_PROP, this.kerberosPassword);
        }
        return properties;
    }

    protected void setFocus() {
        if (this.isURITextFieldFoucs) {
            this.databaseURIText.setFocus();
        } else {
            this.serverHostText.setFocus();
        }
    }
}

