/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.Schedule;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;

public class SybaseASAEventDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
IGenericDdlConstants,
ISybaseASADdlConstants {
    private static final int TYPE_IND = 0;
    private static final int WHERE_IND = 1;
    private static final int SCHEDULE_IND = 2;
    private static final int ENABLE_IND = 3;
    private static final int LOCATION_IND = 4;
    private static final String MODIFY = "MODIFY";

    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASABaseEvent)) {
            return;
        }
        SybaseASABaseEvent event = (SybaseASABaseEvent)element;
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        String[] alters = new String[5];
        ArrayList<String> altSchedules = new ArrayList<String>();
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            int i;
            String[] create = builder.createEvent((Event)event, quoteIdentifiers, qualifyNames, fullSyntax);
            String comment = null;
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                if (r.feature.getFeatureID() == 1 && r.changed == event) {
                    String oldName = (String)r.oldValue;
                    String schemaName = event.getEventCreator().getName();
                    if (quoteIdentifiers) {
                        oldName = SQLUtil.quote((String)oldName, (String)"\"");
                        schemaName = SQLUtil.quote((String)schemaName, (String)"\"");
                    }
                    StringBuffer drop = new StringBuffer(128);
                    drop.append("DROP").append(" ").append("EVENT").append(" ").append(oldName);
                    int i2 = 0;
                    while (i2 < create.length) {
                        script.addCreateEventStatements(create[i2]);
                        ++i2;
                    }
                    script.addDropEventStatements(drop.toString());
                    return;
                }
                if (r.feature.getFeatureID() == 3) {
                    comment = builder.createComment((SQLObject)event, quoteIdentifiers, qualifyNames, true);
                    continue;
                }
                if (r.feature.getFeatureID() == 13) {
                    if (event.getEventType() == null || event.getEventType().getValue() == 0) {
                        alters[0] = "DELETE TYPE" + NEWLINE;
                        continue;
                    }
                    alters[0] = "TYPE " + event.getEventType().getLiteral() + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() == 9) {
                    if (event.getCondition() == null || event.getCondition().trim().equals("")) {
                        alters[1] = "WHERE NULL" + NEWLINE;
                        continue;
                    }
                    alters[1] = "WHERE " + event.getCondition() + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() == 16) {
                    EList oldSch = (EList)r.oldValue;
                    EList schedules = event.getSchedules();
                    if (schedules == null || schedules.isEmpty()) {
                        if (oldSch == null || oldSch.isEmpty()) continue;
                        i = 0;
                        while (i < oldSch.size()) {
                            String sch = "DELETE SCHEDULE " + ((Schedule)oldSch.get(i)).getName() + NEWLINE;
                            altSchedules.add(sch);
                            ++i;
                        }
                        continue;
                    }
                    if (oldSch == null && oldSch.isEmpty()) {
                        i = 0;
                        while (i < schedules.size()) {
                            String sch = "ADD SCHEDULE " + ((Schedule)schedules.get(i)).getName() + NEWLINE;
                            altSchedules.add(sch);
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < oldSch.size()) {
                        boolean found = false;
                        int j = 0;
                        while (j < schedules.size()) {
                            if (((Schedule)schedules.get(j)).getName().equals(((Schedule)oldSch.get(i)).getName())) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            String sch = "DELETE SCHEDULE " + ((Schedule)oldSch.get(i)).getName() + NEWLINE;
                            altSchedules.add(sch);
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < schedules.size()) {
                        boolean found = false;
                        boolean same = false;
                        int i3 = 0;
                        while (i3 < oldSch.size()) {
                            if (((Schedule)schedules.get(j)).getName().equals(((Schedule)oldSch.get(i3)).getName())) {
                                found = true;
                                if (!((Schedule)schedules.get(j)).equals(oldSch.get(i3))) break;
                                same = true;
                                break;
                            }
                            ++i3;
                        }
                        if (found && !same) {
                            String sch = "MODIFY " + builder.getEventSchedule((Schedule)schedules.get(j)) + NEWLINE;
                            altSchedules.add(sch);
                        } else if (!found) {
                            String sch = "ADD " + builder.getEventSchedule((Schedule)schedules.get(j)) + NEWLINE;
                            altSchedules.add(sch);
                        }
                        ++j;
                    }
                    continue;
                }
                if (r.feature.getFeatureID() == 11) {
                    if (event.isEnabled()) {
                        alters[3] = "ENABLE" + NEWLINE;
                        continue;
                    }
                    alters[3] = "DISABLE" + NEWLINE;
                    continue;
                }
                if (r.feature.getFeatureID() != 15) continue;
                alters[4] = "AT " + event.getLocation().getLiteral() + NEWLINE;
            }
            if (records.size() == 1 && ((SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get((int)0)).feature.getFeatureID() == 3) {
                script.addCreateEventStatements(comment);
                return;
            }
            QuickSQLParser parser = QuickSQLParser.getInstance();
            int[] createIndex = parser.find(create[0], new String[]{"CREATE"});
            int[] handlerIndex = parser.find(create[0], new String[]{"HANDLER"});
            if (createIndex[0] >= 0 && handlerIndex[0] >= 0) {
                String alter = "ALTER EVENT " + builder.getName((ENamedElement)event, quoteIdentifiers, false) + NEWLINE;
                if (alters[1] == null && !altSchedules.isEmpty()) {
                    alters[2] = (String)altSchedules.get(0);
                    altSchedules.remove(0);
                }
                i = 0;
                while (i < alters.length) {
                    if (alters[i] != null) {
                        alter = String.valueOf(alter) + alters[i];
                    }
                    ++i;
                }
                alter = String.valueOf(alter) + create[0].substring(handlerIndex[0]);
                script.addCreateEventStatements(alter);
                String alterHeader = "ALTER EVENT " + builder.getName((ENamedElement)event, quoteIdentifiers, false) + NEWLINE;
                for (String sch : altSchedules) {
                    script.addCreateEventStatements(String.valueOf(alterHeader) + sch);
                }
                if (comment != null) {
                    script.addCreateEventStatements(comment);
                }
            } else {
                int i4 = 0;
                while (i4 < create.length) {
                    script.addCreateEventStatements(create[i4]);
                    ++i4;
                }
            }
        }
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
    }
}

