/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.data;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.timeFunction.IArgumentInfo;
import org.eclipse.birt.report.data.adapter.api.timeFunction.ITimeFunction;
import org.eclipse.birt.report.designer.internal.ui.data.IDataServiceProvider;
import org.eclipse.birt.report.designer.internal.ui.data.function.layout.IArgumentLayout;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class DataService {
    private static DataService instance = null;
    private IDataServiceProvider provider;

    private DataService() {
        Object adapter = ElementAdapterManager.getAdapter(this, IDataServiceProvider.class);
        if (adapter instanceof IDataServiceProvider) {
            this.provider = (IDataServiceProvider)adapter;
        }
    }

    public static synchronized DataService getInstance() {
        if (instance == null) {
            instance = new DataService();
        }
        return instance;
    }

    public boolean available() {
        return this.provider != null;
    }

    public void createDataSet() {
        if (this.provider != null) {
            this.provider.createDataSet();
        }
    }

    public void registerSession(DataSetHandle handle, DataRequestSession session) throws BirtException {
        if (this.provider != null) {
            this.provider.registerSession(handle, session);
        }
    }

    public void registerSession(CubeHandle handle, DataRequestSession session) throws BirtException {
        if (this.provider != null) {
            this.provider.registerSession(handle, session);
        }
    }

    public void registerSession(DataSourceHandle handle, DataRequestSession session) throws BirtException {
        if (this.provider != null) {
            this.provider.registerSession(handle, session);
        }
    }

    public void unRegisterSession(DataRequestSession session) throws BirtException {
        if (this.provider != null) {
            this.provider.unRegisterSession(session);
        }
    }

    public List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        if (this.provider != null) {
            return this.provider.getSelectValueList(expression, dataSetHandle, useDataSetFilter);
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, DataEngineContext.DataEngineFlowMode flowMode) throws BirtException {
        if (this.provider != null) {
            return this.provider.getSelectValueList(expression, dataSetHandle, flowMode);
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectValueList(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        if (this.provider != null) {
            return this.provider.getSelectValueList(expression, moduleHandle, dataSetHandle, useDataSetFilter);
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectValueFromBinding(Expression expression, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        if (this.provider != null) {
            return this.provider.getSelectValueFromBinding(expression, dataSetHandle, binding, groupIterator, useDataSetFilter);
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectValueFromBinding(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        if (this.provider != null) {
            return this.provider.getSelectValueFromBinding(expression, moduleHandle, dataSetHandle, binding, groupIterator, useDataSetFilter);
        }
        return Collections.EMPTY_LIST;
    }

    public void updateColumnCache(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        this.provider.updateColumnCache(dataSetHandle, holdEvent);
    }

    public List<IArgumentLayout> getArgumentLayout(ITimeFunction function, List<IArgumentInfo> infos) {
        return this.provider.getArgumentLayout(function, infos);
    }
}

