/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.addon;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.INamespaceMember;
import org.eclipse.app4mc.amalthea.model.Namespace;
import org.eclipse.app4mc.amalthea.model.provider.AmaltheaDefaultLabelProvider;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Namespace Member Table", "description=Shows list of all namespace members"})
public class NamespaceMemberVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(Namespace namespace, Composite parent, IEventBroker broker) {
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Label title = new Label(pane, 0);
        title.setLayoutData((Object)new GridData(768));
        title.setText("\nMembers of namespace \"" + namespace.getQualifiedName() + "\"");
        TableViewer tableViewer = new TableViewer(pane, 2568);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        tableViewer.setLabelProvider((IBaseLabelProvider)new AmaltheaDefaultLabelProvider(){

            public String getText(Object element) {
                return NamespaceMemberVisualization.this.name(element);
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)namespace.getMemberObjects());
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof INamespaceMember) {
                HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                data.put("modelElements", Arrays.asList(firstElement));
                broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
            }
        });
    }

    private String name(Object object) {
        if (object instanceof INamed) {
            String name = ((INamed)object).getName();
            return name == null || name.isEmpty() ? "?" : name;
        }
        return "<undefined>";
    }
}

