/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Draw3DCache
extends Math3DCache {
    private static final Logger log = Logger.getLogger(Draw3DCache.class.getName());
    private static final Comparator<Object> m_bufferComparator = new Comparator<Object>(){

        @Override
        public int compare(Object i_o1, Object i_o2) {
            int i2;
            int i1 = i_o1 instanceof Integer ? ((Integer)i_o1).intValue() : ((Buffer)i_o1).capacity();
            if (i1 < (i2 = i_o2 instanceof Integer ? ((Integer)i_o2).intValue() : ((Buffer)i_o2).capacity())) {
                return -1;
            }
            return 0;
        }
    };
    private static final List<ByteBuffer> m_byteBuffer = new ArrayList<ByteBuffer>();
    private static int m_byteBufferCounter;
    private static final Queue<Dimension> m_dimension;
    private static int m_dimensionCounter;
    private static final List<DoubleBuffer> m_doubleBuffer;
    private static int m_doubleBufferCounter;
    private static final List<FloatBuffer> m_floatBuffer;
    private static int m_floatBufferCounter;
    private static final List<IntBuffer> m_intBuffer;
    private static int m_intBufferCounter;
    private static final Queue<Point> m_point;
    private static int m_pointCounter;
    private static Queue<Rectangle> m_rectangle;
    private static int m_rectangleCounter;

    static {
        m_dimension = new LinkedList<Dimension>();
        m_doubleBuffer = new ArrayList<DoubleBuffer>();
        m_floatBuffer = new ArrayList<FloatBuffer>();
        m_intBuffer = new ArrayList<IntBuffer>();
        m_point = new LinkedList<Point>();
        m_rectangle = new LinkedList<Rectangle>();
    }

    private static ByteBuffer createByteBuffer(int i_capacity) {
        if (m_count && ++m_byteBufferCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " byte buffers, are you properly returning them?");
        }
        return BufferUtils.createByteBuffer(i_capacity);
    }

    private static Dimension createDimension() {
        if (m_count && ++m_dimensionCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " dimensions, are you properly returning them?");
        }
        return new Dimension();
    }

    private static DoubleBuffer createDoubleBuffer(int i_capacity) {
        if (m_count && ++m_doubleBufferCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " double buffers, are you properly returning them?");
        }
        return BufferUtils.createDoubleBuffer(i_capacity);
    }

    private static FloatBuffer createFloatBuffer(int i_capacity) {
        if (m_count && ++m_floatBufferCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " float buffers, are you properly returning them?");
        }
        return BufferUtils.createFloatBuffer(i_capacity);
    }

    private static IntBuffer createIntBuffer(int i_capacity) {
        if (m_count && ++m_intBufferCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " int buffers, are you properly returning them?");
        }
        return BufferUtils.createIntBuffer(i_capacity);
    }

    private static Point createPoint() {
        if (m_count && ++m_pointCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " points, are you properly returning them?");
        }
        return new Point();
    }

    private static Rectangle createRectangle() {
        if (m_count && ++m_rectangleCounter > m_counterThreshold) {
            log.warning("created more than " + m_counterThreshold + " rectangles, are you properly returning them?");
        }
        return new Rectangle();
    }

    private static <T extends Buffer> T doGetBuffer(List<T> i_buffers, int i_capacity) {
        int index = Collections.binarySearch(i_buffers, i_capacity, m_bufferComparator);
        if (index >= 0) {
            Buffer buffer = (Buffer)i_buffers.remove(index);
            buffer.limit(i_capacity);
            return (T)buffer;
        }
        return null;
    }

    private static <T extends Buffer> void doReturnBuffer(List<T> i_buffers, T i_buffer) {
        int index = Collections.binarySearch(i_buffers, i_buffer, m_bufferComparator);
        if (index < 0) {
            index = -index - 1;
        }
        i_buffers.add(index, i_buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getByteBuffer(int i_capacity) {
        ByteBuffer buffer;
        if (m_synchronized) {
            List<ByteBuffer> list = m_byteBuffer;
            synchronized (list) {
                buffer = Draw3DCache.doGetBuffer(m_byteBuffer, i_capacity);
            }
        } else {
            buffer = Draw3DCache.doGetBuffer(m_byteBuffer, i_capacity);
        }
        if (buffer == null) {
            buffer = Draw3DCache.createByteBuffer(i_capacity);
        } else {
            buffer.limit(i_capacity);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getDimension() {
        if (m_synchronized) {
            Queue<Dimension> queue = m_dimension;
            synchronized (queue) {
                if (m_dimension.isEmpty()) {
                    return Draw3DCache.createDimension();
                }
                return m_dimension.remove();
            }
        }
        if (m_dimension.isEmpty()) {
            return Draw3DCache.createDimension();
        }
        return m_dimension.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoubleBuffer getDoubleBuffer(int i_capacity) {
        DoubleBuffer buffer;
        if (m_synchronized) {
            List<DoubleBuffer> list = m_doubleBuffer;
            synchronized (list) {
                buffer = Draw3DCache.doGetBuffer(m_doubleBuffer, i_capacity);
            }
        } else {
            buffer = Draw3DCache.doGetBuffer(m_doubleBuffer, i_capacity);
        }
        if (buffer == null) {
            buffer = Draw3DCache.createDoubleBuffer(i_capacity);
        } else {
            buffer.limit(i_capacity);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer getFloatBuffer(int i_capacity) {
        FloatBuffer buffer;
        if (m_synchronized) {
            List<FloatBuffer> list = m_floatBuffer;
            synchronized (list) {
                buffer = Draw3DCache.doGetBuffer(m_floatBuffer, i_capacity);
            }
        } else {
            buffer = Draw3DCache.doGetBuffer(m_floatBuffer, i_capacity);
        }
        if (buffer == null) {
            buffer = Draw3DCache.createFloatBuffer(i_capacity);
        } else {
            buffer.limit(i_capacity);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer getIntBuffer(int i_capacity) {
        IntBuffer buffer;
        if (m_synchronized) {
            List<IntBuffer> list = m_intBuffer;
            synchronized (list) {
                buffer = Draw3DCache.doGetBuffer(m_intBuffer, i_capacity);
            }
        } else {
            buffer = Draw3DCache.doGetBuffer(m_intBuffer, i_capacity);
        }
        if (buffer == null) {
            buffer = Draw3DCache.createIntBuffer(i_capacity);
        } else {
            buffer.limit(i_capacity);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getPoint() {
        if (m_synchronized) {
            Queue<Point> queue = m_point;
            synchronized (queue) {
                if (m_point.isEmpty()) {
                    return Draw3DCache.createPoint();
                }
                return m_point.remove();
            }
        }
        if (m_point.isEmpty()) {
            return Draw3DCache.createPoint();
        }
        return m_point.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getRectangle() {
        if (m_synchronized) {
            Queue<Rectangle> queue = m_rectangle;
            synchronized (queue) {
                if (m_rectangle.isEmpty()) {
                    return Draw3DCache.createRectangle();
                }
                return m_rectangle.remove();
            }
        }
        if (m_rectangle.isEmpty()) {
            return Draw3DCache.createRectangle();
        }
        return m_rectangle.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnByteBuffer(ByteBuffer ... i_bs) {
        if (m_synchronized) {
            List<FloatBuffer> list = m_floatBuffer;
            synchronized (list) {
                ByteBuffer[] byteBufferArray = i_bs;
                int n = i_bs.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer b = byteBufferArray[n2];
                    if (b != null) {
                        Draw3DCache.doReturnBuffer(m_byteBuffer, b);
                    }
                    ++n2;
                }
            }
        } else {
            ByteBuffer[] byteBufferArray = i_bs;
            int n = i_bs.length;
            int n3 = 0;
            while (n3 < n) {
                ByteBuffer b = byteBufferArray[n3];
                if (b != null) {
                    Draw3DCache.doReturnBuffer(m_byteBuffer, b);
                }
                ++n3;
            }
        }
        if (m_count && m_byteBuffer.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " byte buffers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnDimension(Dimension ... i_ds) {
        if (m_synchronized) {
            Queue<Dimension> queue = m_dimension;
            synchronized (queue) {
                Dimension[] dimensionArray = i_ds;
                int n = i_ds.length;
                int n2 = 0;
                while (n2 < n) {
                    Dimension d = dimensionArray[n2];
                    if (d != null) {
                        m_dimension.offer(d);
                    }
                    ++n2;
                }
            }
        } else {
            Dimension[] dimensionArray = i_ds;
            int n = i_ds.length;
            int n3 = 0;
            while (n3 < n) {
                Dimension d = dimensionArray[n3];
                if (d != null) {
                    m_dimension.offer(d);
                }
                ++n3;
            }
        }
        if (m_count && m_dimension.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " dimensions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnDoubleBuffer(DoubleBuffer ... i_bs) {
        if (m_synchronized) {
            List<DoubleBuffer> list = m_doubleBuffer;
            synchronized (list) {
                DoubleBuffer[] doubleBufferArray = i_bs;
                int n = i_bs.length;
                int n2 = 0;
                while (n2 < n) {
                    DoubleBuffer b = doubleBufferArray[n2];
                    if (b != null) {
                        Draw3DCache.doReturnBuffer(m_doubleBuffer, b);
                    }
                    ++n2;
                }
            }
        } else {
            DoubleBuffer[] doubleBufferArray = i_bs;
            int n = i_bs.length;
            int n3 = 0;
            while (n3 < n) {
                DoubleBuffer b = doubleBufferArray[n3];
                if (b != null) {
                    Draw3DCache.doReturnBuffer(m_doubleBuffer, b);
                }
                ++n3;
            }
        }
        if (m_count && m_doubleBuffer.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " double buffers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnFloatBuffer(FloatBuffer ... i_bs) {
        if (m_synchronized) {
            List<FloatBuffer> list = m_floatBuffer;
            synchronized (list) {
                FloatBuffer[] floatBufferArray = i_bs;
                int n = i_bs.length;
                int n2 = 0;
                while (n2 < n) {
                    FloatBuffer b = floatBufferArray[n2];
                    if (b != null) {
                        Draw3DCache.doReturnBuffer(m_floatBuffer, b);
                    }
                    ++n2;
                }
            }
        } else {
            FloatBuffer[] floatBufferArray = i_bs;
            int n = i_bs.length;
            int n3 = 0;
            while (n3 < n) {
                FloatBuffer b = floatBufferArray[n3];
                if (b != null) {
                    Draw3DCache.doReturnBuffer(m_floatBuffer, b);
                }
                ++n3;
            }
        }
        if (m_count && m_floatBuffer.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " float buffers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnIntBuffer(IntBuffer ... i_bs) {
        if (m_synchronized) {
            List<IntBuffer> list = m_intBuffer;
            synchronized (list) {
                IntBuffer[] intBufferArray = i_bs;
                int n = i_bs.length;
                int n2 = 0;
                while (n2 < n) {
                    IntBuffer b = intBufferArray[n2];
                    if (b != null) {
                        Draw3DCache.doReturnBuffer(m_intBuffer, b);
                    }
                    ++n2;
                }
            }
        } else {
            IntBuffer[] intBufferArray = i_bs;
            int n = i_bs.length;
            int n3 = 0;
            while (n3 < n) {
                IntBuffer b = intBufferArray[n3];
                if (b != null) {
                    Draw3DCache.doReturnBuffer(m_intBuffer, b);
                }
                ++n3;
            }
        }
        if (m_count && m_intBuffer.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " int buffers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnPoint(Point ... i_ps) {
        if (m_synchronized) {
            Queue<Point> queue = m_point;
            synchronized (queue) {
                Point[] pointArray = i_ps;
                int n = i_ps.length;
                int n2 = 0;
                while (n2 < n) {
                    Point p = pointArray[n2];
                    if (p != null) {
                        m_point.offer(p);
                    }
                    ++n2;
                }
            }
        } else {
            Point[] pointArray = i_ps;
            int n = i_ps.length;
            int n3 = 0;
            while (n3 < n) {
                Point p = pointArray[n3];
                if (p != null) {
                    m_point.offer(p);
                }
                ++n3;
            }
        }
        if (m_count && m_point.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " points");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnRectangle(Rectangle ... i_rs) {
        if (m_synchronized) {
            Queue<Rectangle> queue = m_rectangle;
            synchronized (queue) {
                Rectangle[] rectangleArray = i_rs;
                int n = i_rs.length;
                int n2 = 0;
                while (n2 < n) {
                    Rectangle r = rectangleArray[n2];
                    if (r != null) {
                        m_rectangle.offer(r);
                    }
                    ++n2;
                }
            }
        } else {
            Rectangle[] rectangleArray = i_rs;
            int n = i_rs.length;
            int n3 = 0;
            while (n3 < n) {
                Rectangle r = rectangleArray[n3];
                if (r != null) {
                    m_rectangle.offer(r);
                }
                ++n3;
            }
        }
        if (m_count && m_rectangle.size() > m_instanceThreshold) {
            log.warning("cache contains more than " + m_instanceThreshold + " rectangles");
        }
    }
}

