/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.RandomAccess;

public class Conversions {
    public static Object doWrapArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> arrayClass = object.getClass();
        if (arrayClass.isArray()) {
            if (arrayClass.getComponentType().isPrimitive()) {
                WrappedPrimitiveArray result = WrappedPrimitiveArray.create(object);
                return result;
            }
            WrappedArray<Object> result = WrappedArray.create((Object[])object);
            return result;
        }
        return object;
    }

    public static Object unwrapArray(Object value) {
        if (value instanceof WrappedArray) {
            return ((WrappedArray)value).internalToArray();
        }
        if (value instanceof WrappedPrimitiveArray) {
            return ((WrappedPrimitiveArray)value).internalToArray();
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedArray<T>
    extends AbstractList<T>
    implements RandomAccess {
        private T[] array;

        public static <T> WrappedArray<T> create(T[] array) {
            return new WrappedArray<T>(array);
        }

        protected WrappedArray(T[] array) {
            this.array = array;
        }

        @Override
        public T get(int index) {
            return this.array[index];
        }

        @Override
        public T set(int index, T element) {
            T old = this.array[index];
            this.array[index] = element;
            ++this.modCount;
            return old;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        public T[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedPrimitiveArray
    extends AbstractList<Object>
    implements RandomAccess {
        private Object array;
        private int size;

        public static WrappedPrimitiveArray create(Object array) {
            return new WrappedPrimitiveArray(array);
        }

        protected WrappedPrimitiveArray(Object array) {
            this.array = array;
            this.size = Array.getLength(array);
        }

        @Override
        public Object get(int index) {
            return Array.get(this.array, index);
        }

        @Override
        public Object set(int index, Object element) {
            Object old = this.get(index);
            Array.set(this.array, index, element);
            ++this.modCount;
            return old;
        }

        @Override
        public int size() {
            return this.size;
        }

        public Object internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }
}

