/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.xtext.ui.editor.findrefs.EditorResourceAccess;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResult;

public class ReferenceQuery
implements ISearchQuery {
    @Inject
    private IReferenceFinder finder;
    @Inject
    protected EditorResourceAccess localContextProvider;
    private ReferenceSearchResult searchResult;
    private IReferenceFinder.IQueryData queryData;

    public void init(IReferenceFinder.IQueryData queryData) {
        this.queryData = queryData;
        this.searchResult = this.createSearchResult();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.queryData.getLabel();
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.reset();
        this.finder.findAllReferences(this.queryData, this.localContextProvider, this.searchResult, monitor);
        this.searchResult.finish();
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    protected ReferenceSearchResult createSearchResult() {
        return new ReferenceSearchResult(this);
    }
}

