/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.internal.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccess;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;
import org.eclipse.xtext.generator.serializer.JavaFile;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticSequencerUtil {
    @Inject
    protected IContextProvider contextProvider;
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    @Inject
    protected Grammar grammar;
    protected List<Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>>> ambiguousTransitions;
    @Inject
    protected GrammarAccess grammarAccess;

    protected List<ISyntacticSequencerPDAProvider.ISynAbsorberState> getAllPDAs() {
        ArrayList result = Lists.newArrayList();
        for (EObject context : this.contextProvider.getAllContexts(this.grammar)) {
            for (EClass type : this.contextProvider.getTypesForContext(context)) {
                result.add(this.pdaProvider.getPDA(context, type));
            }
        }
        return result;
    }

    protected void collectAllAmbiguousTransitions(ISyntacticSequencerPDAProvider.ISynFollowerOwner state, Set<ISyntacticSequencerPDAProvider.ISynTransition> result, Set<Object> visited) {
        if (!visited.add(state)) {
            return;
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynTransition && ((ISyntacticSequencerPDAProvider.ISynTransition)state).isSyntacticallyAmbiguous()) {
            result.add((ISyntacticSequencerPDAProvider.ISynTransition)state);
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            for (ISyntacticSequencerPDAProvider.ISynTransition trans : ((ISyntacticSequencerPDAProvider.ISynAbsorberState)state).getOutTransitions()) {
                this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)trans, result, visited);
            }
        } else {
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)follower, result, visited);
            }
        }
    }

    protected Set<ISyntacticSequencerPDAProvider.ISynTransition> getAllAmbiguousTransitions() {
        HashSet result = Sets.newHashSet();
        for (ISyntacticSequencerPDAProvider.ISynAbsorberState start : this.getAllPDAs()) {
            this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)start, result, Sets.newHashSet());
        }
        return result;
    }

    public List<Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>>> getAllAmbiguousTransitionsBySyntax() {
        if (this.ambiguousTransitions != null) {
            return this.ambiguousTransitions;
        }
        HashMap result = Maps.newHashMap();
        for (ISyntacticSequencerPDAProvider.ISynTransition iSynTransition : this.getAllAmbiguousTransitions()) {
            GrammarAlias.AbstractElementAlias syntax = iSynTransition.getAmbiguousSyntax();
            if (syntax == null) continue;
            List list = (List)result.get(syntax);
            if (list == null) {
                list = Lists.newArrayList();
                result.put(syntax, list);
            }
            list.add(iSynTransition);
        }
        this.ambiguousTransitions = Lists.newArrayList();
        for (Map.Entry entry : result.entrySet()) {
            this.ambiguousTransitions.add((Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>>)Tuples.create((Object)this.elementAliasToIdentifyer((GrammarAlias.AbstractElementAlias)entry.getKey()), (Object)((GrammarAlias.AbstractElementAlias)entry.getKey()), (Object)((List)entry.getValue())));
        }
        Collections.sort(this.ambiguousTransitions, new Comparator<Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>>>(){

            @Override
            public int compare(Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>> o1, Triple<String, GrammarAlias.AbstractElementAlias, List<ISyntacticSequencerPDAProvider.ISynTransition>> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        return this.ambiguousTransitions;
    }

    protected String elementAliasToIdentifyer(GrammarAlias.AbstractElementAlias alias, Set<String> rules, boolean isNested) {
        String card = null;
        if (alias.isMany() && alias.isOptional()) {
            card = "a";
        } else if (alias.isMany()) {
            card = "p";
        } else if (alias.isOptional()) {
            card = "q";
        }
        if (alias instanceof GrammarAlias.TokenAlias) {
            GrammarAlias.TokenAlias ele = (GrammarAlias.TokenAlias)alias;
            rules.add(GrammarUtil.containingRule((EObject)ele.getToken()).getName());
            card = card == null ? "" : "_" + card;
            return String.valueOf(GrammarAccessUtil.getUniqueElementName(ele.getToken())) + card;
        }
        if (alias instanceof GrammarAlias.GroupAlias) {
            ArrayList children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer(child, rules, true));
            }
            String body = Join.join((String)"_", (Iterable)children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        if (alias instanceof GrammarAlias.AlternativeAlias) {
            ArrayList children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.AlternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer(child, rules, true));
            }
            Collections.sort(children);
            String body = Join.join((String)"_or_", (Iterable)children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        throw new RuntimeException("unknown element");
    }

    public String elementAliasToConstructor(GrammarAlias.AbstractElementAlias alias, JavaFile file) {
        String many = String.valueOf(alias.isMany());
        String optional = String.valueOf(alias.isOptional());
        if (alias instanceof GrammarAlias.TokenAlias) {
            GrammarAlias.TokenAlias ele = (GrammarAlias.TokenAlias)alias;
            String eleAlias = file.imported(GrammarAlias.TokenAlias.class);
            String eleAcc = "grammarAccess." + this.grammarAccess.gaAccessor((EObject)ele.getToken());
            return "new " + eleAlias + "(" + optional + ", " + many + ", " + eleAcc + ")";
        }
        if (alias instanceof GrammarAlias.GroupAlias) {
            ArrayList children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor(child, file));
            }
            String body = Join.join((String)", ", (Iterable)children);
            String grpAlias = file.imported(GrammarAlias.GroupAlias.class);
            return "new " + grpAlias + "(" + optional + ", " + many + ", " + body + ")";
        }
        if (alias instanceof GrammarAlias.AlternativeAlias) {
            ArrayList children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.AlternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor(child, file));
            }
            Collections.sort(children);
            String body = Join.join((String)", ", (Iterable)children);
            String altAlias = file.imported(GrammarAlias.AlternativeAlias.class);
            return "new " + altAlias + "(" + optional + ", " + many + ", " + body + ")";
        }
        throw new RuntimeException("unknown element");
    }

    protected String elementAliasToIdentifyer(GrammarAlias.AbstractElementAlias alias) {
        HashSet rulesSet = Sets.newHashSet();
        String body = this.elementAliasToIdentifyer(alias, rulesSet, false);
        ArrayList rulesList = Lists.newArrayList((Iterable)rulesSet);
        Collections.sort(rulesList);
        String rule = Join.join((String)"_", (Iterable)rulesList);
        return String.valueOf(rule) + "_" + body;
    }
}

