/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.OtherBreakpointCategory;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractBreakpointOrganizerDelegate
implements IBreakpointOrganizerDelegate {
    private ListenerList fListeners = new ListenerList();

    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        return category instanceof OtherBreakpointCategory;
    }

    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        return category instanceof OtherBreakpointCategory;
    }

    public void dispose() {
        this.fListeners = new ListenerList();
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void fireCategoryChanged(IAdaptable category) {
        if (this.fListeners.isEmpty()) {
            return;
        }
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, P_CATEGORY_CHANGED, (Object)category, null);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    public IAdaptable[] getCategories() {
        return null;
    }
}

