/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.integrate;

import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.integrate.SimpleHyperlinkBuilder;
import org.eclipse.birt.chart.ui.swt.interfaces.IAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SimpleUIServiceProviderImpl
implements IUIServiceProvider {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/integrate");

    public String invoke(String sExpression, Object oContext, String sTitle) {
        logger.log(2, Messages.getString("SimpleUIServiceProviderImpl.Warn.Placeholder"));
        return sExpression;
    }

    public String invoke(String sExpression, Object oContext, String sTitle, boolean isChartProvider) {
        logger.log(2, Messages.getString("SimpleUIServiceProviderImpl.Warn.Placeholder"));
        return sExpression;
    }

    public String[] validate(Chart chartModel, Object oContext) {
        return null;
    }

    public List getRegisteredKeys() {
        Vector<String> list = new Vector<String>();
        list.add("SampleKey");
        return list;
    }

    public String getValue(String sKey) {
        if (sKey.equals("SampleKey")) {
            return "Sample Value";
        }
        return null;
    }

    public double getConvertedValue(double dOriginalValue, String sFromUnits, String sToUnits) {
        return dOriginalValue;
    }

    public String invoke(int command, String value, Object context, String sTitle) throws ChartException {
        switch (command) {
            case 6: 
            case 7: {
                Shell shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, "org.eclipse.birt.chart.cshelp.EditURL_ID");
                SimpleHyperlinkBuilder hb = new SimpleHyperlinkBuilder(shell);
                try {
                    hb.setInputString(value);
                    if (sTitle != null) {
                        hb.setTitle(String.valueOf(hb.getTitle()) + " - " + sTitle);
                    }
                    if (hb.open() != 0) break;
                    value = hb.getResultString();
                    break;
                }
                catch (Exception e) {
                    throw new ChartException("org.eclipse.birt.chart.ui", 13, (Throwable)e);
                }
            }
        }
        return value;
    }

    public boolean isInvokingSupported() {
        return true;
    }

    public boolean isEclipseModeSupported() {
        return false;
    }

    public Object invoke(IUIServiceProvider.Command command, Object ... inData) throws ChartException {
        IExpressionButton outData = null;
        switch (command) {
            case EXPRESS_BUTTON_CREATE: {
                IExpressionButton ceb;
                final Control control = (Control)inData[1];
                new Label((Composite)inData[0], 0);
                outData = ceb = new IExpressionButton(){

                    @Override
                    public void setExpression(String expr) {
                        if (expr != null) {
                            ChartUIUtil.setText(control, expr);
                        }
                    }

                    @Override
                    public void setEnabled(boolean bEnabled) {
                        control.setEnabled(bEnabled);
                    }

                    @Override
                    public boolean isEnabled() {
                        return control.isEnabled();
                    }

                    @Override
                    public String getExpression() {
                        return ChartUIUtil.getText(control);
                    }

                    @Override
                    public String getDisplayExpression() {
                        return this.getExpression();
                    }

                    @Override
                    public void addListener(Listener listener) {
                    }

                    @Override
                    public void setAccessor(ChartUIUtil.EAttributeAccessor<String> accessor) {
                    }

                    @Override
                    public String getExpressionType() {
                        return null;
                    }

                    @Override
                    public boolean isCube() {
                        return false;
                    }

                    @Override
                    public void setBindingName(String bindingName, boolean bNotifyEvents) {
                    }

                    @Override
                    public void setExpression(String expr, boolean bNotifyEvents) {
                    }

                    @Override
                    public void setAssitField(IAssistField assistField) {
                    }

                    @Override
                    public void setPredefinedQuery(Object[] predefinedQuery) {
                    }
                };
            }
        }
        return outData;
    }
}

