/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.model.LocatedAgent;
import org.ascape.model.Scape;
import org.ascape.model.event.ScapeEvent;
import org.ascape.util.vis.ColorFeature;
import org.ascape.view.vis.StretchyView;
import org.eclipse.draw2d.Graphics;

public class FixedStretchyView
extends StretchyView {
    private static final long serialVersionUID = 8924203714365438295L;
    private Agent[] agentView;
    private boolean[] agentFoundAt;
    boolean removeGaps;

    public FixedStretchyView(String name, int maxElements, int maxDisplayElements) {
        super(name, maxElements, maxDisplayElements);
    }

    public FixedStretchyView() {
        this("Fixed Stretchy view", 5000, 5000);
    }

    public void scapeInitialized(ScapeEvent scapeEvent) {
        this.agentView = new Agent[this.maxAgents];
        this.agentFoundAt = new boolean[this.maxAgents];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScapeGraphics(Graphics graphics) {
        graphics.fillRectangle(0, 0, this.image.getBounds().width, this.image.getBounds().height);
        if (this.getScape() != null && this.getScape().isInitialized()) {
            int i;
            int agentsSize = this.getScape().getSize();
            if (!this.removeGaps) {
                i = 0;
                while (i < this.agentView.length) {
                    this.agentFoundAt[i] = false;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.agentView.length) {
                    this.agentFoundAt[i] = false;
                    this.agentView[i] = null;
                    ++i;
                }
            }
            Scape scape = this.getScape();
            synchronized (scape) {
                for (Agent agent : this.getScape()) {
                    boolean agentFound = false;
                    int firstNull = agentsSize;
                    int i2 = 0;
                    while (i2 < this.agentView.length) {
                        if (this.agentView[i2] == null) {
                            if (firstNull == agentsSize) {
                                firstNull = i2;
                            }
                        } else if (this.agentView[i2] == agent) {
                            agentFound = true;
                            this.agentFoundAt[i2] = true;
                        }
                        ++i2;
                    }
                    if (agentFound) continue;
                    this.agentView[firstNull] = agent;
                    this.agentFoundAt[firstNull] = true;
                }
                int i3 = 0;
                while (i3 < this.agentView.length) {
                    if (!this.agentFoundAt[i3]) {
                        this.agentView[i3] = null;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.agentView.length) {
                    Agent agent = this.agentView[i3];
                    if (agent != null) {
                        this.drawAgentAt(graphics, agent, i3);
                    }
                    ++i3;
                }
            }
        }
        super.updateScapeGraphics(graphics);
    }

    @Override
    public Agent getAgentAtPixel(int x, int y) {
        int position = x / this.agentSize;
        return this.agentView[position];
    }

    @Override
    public void drawSelectedAgent(Graphics graphics, LocatedAgent a) {
        int i = 0;
        while (i < this.agentView.length) {
            if (a == this.agentView[i]) {
                int s = this.maxDisplayAgents * this.agentSize;
                graphics.setForegroundColor(ColorFeature.HIGHLIGHT_AGENT_COLOR);
                graphics.drawRectangle(i * this.agentSize - 1, this.getSize().width - s - 1, this.agentSize, s);
            }
            ++i;
        }
    }

    public boolean isRemoveGaps() {
        return this.removeGaps;
    }

    public void setRemoveGaps(boolean removeGaps) {
        this.removeGaps = removeGaps;
    }
}

