/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import org.ascape.util.data.UnitIntervalDataPoint;
import org.ascape.util.vis.ColorFeatureConcrete;
import org.eclipse.swt.graphics.Color;

public class ColorFeatureGradiated
extends ColorFeatureConcrete {
    private static final long serialVersionUID = 1L;
    protected float redMinimum;
    protected float greenMinimum;
    protected float blueMinimum;
    protected float redMaximum;
    protected float greenMaximum;
    protected float blueMaximum;
    protected float redBase;
    protected float greenBase;
    protected float blueBase;
    protected UnitIntervalDataPoint dataPoint;

    public ColorFeatureGradiated() {
        this.setMinimumColor(WHITE);
        this.setMaximumColor(YELLOW);
    }

    public ColorFeatureGradiated(String name) {
        super(name);
        this.setMinimumColor(WHITE);
        this.setMaximumColor(YELLOW);
    }

    public ColorFeatureGradiated(Color maximumColor, UnitIntervalDataPoint dataPoint) {
        this.setDataPoint(dataPoint);
        this.setMinimumColor(WHITE);
        this.setMaximumColor(YELLOW);
    }

    public ColorFeatureGradiated(String name, Color maximumColor, UnitIntervalDataPoint dataPoint) {
        super(name);
        this.setDataPoint(dataPoint);
        this.setMinimumColor(WHITE);
        this.setMaximumColor(maximumColor);
    }

    public ColorFeatureGradiated(String name, Color maximumColor, Color minimumColor, UnitIntervalDataPoint dataPoint) {
        super(name);
        this.setDataPoint(dataPoint);
        this.setMinimumColor(minimumColor);
        this.setMaximumColor(maximumColor);
    }

    public UnitIntervalDataPoint getDataPoint() {
        return this.dataPoint;
    }

    public void setDataPoint(UnitIntervalDataPoint dataPoint) {
        this.dataPoint = dataPoint;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.name;
        }
        return this.dataPoint.getName();
    }

    @Override
    public Color getColor(Object object) {
        float agentColor = (float)this.dataPoint.getBracketedValue(object);
        float r = this.redMinimum + agentColor * (this.redMaximum - this.redMinimum);
        float g = this.greenMinimum + agentColor * (this.greenMaximum - this.greenMinimum);
        float b = this.blueMinimum + agentColor * (this.blueMaximum - this.blueMinimum);
        return ColorFeatureGradiated.create(r, g, b);
    }

    public Color getColor(Object object, float alpha) {
        float agentColor = (float)this.dataPoint.getBracketedValue(object);
        float r = this.redMinimum + agentColor * (this.redMaximum - this.redMinimum);
        float g = this.greenMinimum + agentColor * (this.greenMaximum - this.greenMinimum);
        float b = this.blueMinimum + agentColor * (this.blueMaximum - this.blueMinimum);
        return ColorFeatureGradiated.create((int)r, (int)g, (int)b, (int)alpha);
    }

    private void calculateColorValues() {
    }

    public void setMinimumColor(Color valueColor) {
        this.redMinimum = (float)valueColor.getRed() / 255.0f;
        this.greenMinimum = (float)valueColor.getGreen() / 255.0f;
        this.blueMinimum = (float)valueColor.getBlue() / 255.0f;
        this.calculateColorValues();
    }

    public void setMaximumColor(Color valueColor) {
        this.redMaximum = (float)valueColor.getRed() / 255.0f;
        this.greenMaximum = (float)valueColor.getGreen() / 255.0f;
        this.blueMaximum = (float)valueColor.getBlue() / 255.0f;
        this.calculateColorValues();
    }

    public Object clone() {
        try {
            ColorFeatureGradiated clone = (ColorFeatureGradiated)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

