/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.view.IModelPart;
import org.eclipse.amp.axf.view.ModelInput;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class ModelViewPart
extends ViewPart
implements IModelPart,
IPropertyChangeListener {
    IModel model;
    protected PropertySheetPage propertySheetPage;
    List<ILifeCycleListener> modelListeners = new ArrayList<ILifeCycleListener>();

    public void createPartControl(Composite parent) {
        this.propertySheetPage = new PropertySheetPage();
        IPropertySourceProvider source = (IPropertySourceProvider)Platform.getAdapterManager().getAdapter((Object)this, IPropertySourceProvider.class);
        if (source != null) {
            this.propertySheetPage.setPropertySourceProvider(source);
        }
    }

    protected void createSelectionListener(ISelectionProvider provider) {
    }

    protected void removeSelectionListener(ISelectionProvider provider) {
    }

    public void setInput(IEditorInput input) {
        this.model = input != null ? ((ModelInput)input).getModel() : null;
    }

    public void setPartName(String newName) {
        super.setPartName(newName);
    }

    public String getName() {
        return String.valueOf(this.model != null ? String.valueOf(this.model.getName()) + " " : "") + "View";
    }

    public PropertySheetPage getPropertySheetPage() {
        return this.propertySheetPage;
    }

    @Override
    public void createModelListeners() {
        this.addModelListener((ILifeCycleListener)new PropertyRefreshListener());
    }

    public IModel getModel() {
        return this.model;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void setModel(IModel model) {
        this.model = model;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.model != null) {
            for (ILifeCycleListener listener : this.getModelListeners()) {
                if (!this.model.getModelListeners().contains(listener)) continue;
                if (listener instanceof SWTAsyncModelListener) {
                    ((SWTAsyncModelListener)listener).forceModelNotify(this.model);
                }
                if (!this.model.getModelListeners().contains(listener)) continue;
                this.model.removeModelListener(listener);
            }
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        this.propertySheetPage = null;
        super.dispose();
    }

    @Override
    public void addModelListener(ILifeCycleListener listener) {
        this.modelListeners.add(listener);
        this.model.addModelListener(listener);
    }

    @Override
    public Collection<ILifeCycleListener> getModelListeners() {
        return this.modelListeners;
    }

    @Override
    public void removeModelListener(ILifeCycleListener view) {
        this.modelListeners.remove(view);
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == IModel.class) {
            return this.getModel();
        }
        return super.getAdapter(type);
    }

    public boolean isSingle() {
        return false;
    }

    class PropertyRefreshListener
    extends SWTAsyncModelListener {
        public PropertyRefreshListener() {
            super(null, "Property Refresh", 2500L);
        }

        @Override
        public void update(IModel model) {
            if (ModelViewPart.this.propertySheetPage != null && ModelViewPart.this.propertySheetPage.getControl() != null && ModelViewPart.this.propertySheetPage.getControl().isVisible()) {
                ModelViewPart.this.propertySheetPage.refresh();
            }
            this.endPainting();
        }

        @Override
        public Control getWidget() {
            if (ModelViewPart.this.propertySheetPage != null) {
                return ModelViewPart.this.propertySheetPage.getControl();
            }
            return null;
        }
    }
}

