/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.picking;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.picking.Hit;

public class HitImpl
implements Hit {
    private float m_distance;
    private IFigure3D m_figure;
    private IVector3f m_rayDirection;
    private IVector3f m_rayOrigin;
    private IFigure m_searchResult;
    private Vector3f m_wLocation;

    public HitImpl(IFigure3D i_figure, IFigure i_searchResult, float i_distance, IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        if (i_figure == null) {
            throw new NullPointerException("i_figure must not be null");
        }
        if (i_searchResult == null) {
            throw new NullPointerException("i_searchResult must not be null");
        }
        if (i_rayOrigin == null) {
            throw new NullPointerException("i_rayOrigin must not be null");
        }
        if (i_rayDirection == null) {
            throw new NullPointerException("i_rayDirection must not be null");
        }
        this.m_figure = i_figure;
        this.m_searchResult = i_searchResult;
        this.m_distance = i_distance;
        this.m_rayOrigin = i_rayOrigin;
        this.m_rayDirection = i_rayDirection;
    }

    public float getDistance() {
        return this.m_distance;
    }

    public IFigure3D getFigure3D() {
        return this.m_figure;
    }

    public IFigure getSearchResult() {
        return this.m_searchResult;
    }

    public Vector3f getWorldLocation(Vector3f o_result) {
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (this.m_wLocation == null) {
            this.m_wLocation = new Vector3fImpl(this.m_rayDirection);
            this.m_wLocation.scale(this.m_distance);
            Math3D.add((IVector3f)this.m_rayOrigin, (IVector3f)this.m_wLocation, (Vector3f)this.m_wLocation);
        }
        result.set((IVector3f)this.m_wLocation);
        return result;
    }

    public boolean isCloserThan(Hit i_hit) {
        if (i_hit == null) {
            throw new NullPointerException("i_hit must not be null");
        }
        return this.m_distance < i_hit.getDistance();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Hit[figure=");
        b.append(this.m_figure);
        b.append(", distance: ");
        b.append(this.m_distance);
        b.append(", world: ");
        b.append(this.m_wLocation);
        b.append("]");
        return b.toString();
    }
}

