/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public abstract class AbstractSurface
implements ISurface {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Vector3f[] m_cachedProjection;
    private Vector3f m_normal = new Vector3fImpl();
    private boolean m_normalValid = false;
    private Vector3f m_upVector = new Vector3fImpl();
    private boolean m_upVectorValid = false;
    private Matrix4f m_surfaceToWorld = new Matrix4fImpl();
    private boolean m_surfaceToWorldValid = false;
    private Matrix4f m_worldToSurface = new Matrix4fImpl();
    private boolean m_worldToSurfaceValid = false;

    protected abstract void calculateNormal(Vector3f var1);

    protected void calculateUpVector(Vector3f o_upVector) {
        this.getYAxis(o_upVector);
        Math3D.negate((IVector3f)o_upVector, (Vector3f)o_upVector);
    }

    protected void coordinateSystemChanged() {
        this.m_surfaceToWorldValid = false;
        this.m_worldToSurfaceValid = false;
        this.m_normalValid = false;
        this.m_upVectorValid = false;
        this.m_cachedProjection = null;
    }

    public IVector3f getNormal() {
        if (!this.m_normalValid) {
            this.calculateNormal(this.m_normal);
            this.m_normalValid = true;
        }
        return this.m_normal;
    }

    public IVector3f getUpVector() {
        if (!this.m_upVectorValid) {
            this.calculateUpVector(this.m_upVector);
            this.m_upVectorValid = true;
        }
        return this.m_upVector;
    }

    protected abstract Vector3f getOrigin(Vector3f var1);

    public Point getSurfaceLocation2D(float i_wx, float i_wy, float i_wz, Point io_result) {
        Point point;
        Vector3f w = Draw3DCache.getVector3f();
        try {
            w.set(i_wx, i_wy, i_wz);
            point = this.getSurfaceLocation2D((IVector3f)w, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
        return point;
    }

    public Point getSurfaceLocation2D(IVector3f i_rayOrigin, IVector3f i_rayDirection, Point io_result) {
        Point point;
        Point result = io_result;
        if (result == null) {
            result = new Point();
        }
        Vector3f sLocation = Draw3DCache.getVector3f();
        try {
            this.getSurfaceLocation3D(i_rayOrigin, i_rayDirection, sLocation);
            result.x = (int)sLocation.getX();
            result.y = (int)sLocation.getY();
            point = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{sLocation});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{sLocation});
        return point;
    }

    public Point getSurfaceLocation2D(IVector3f i_world, Point io_result) {
        Point point;
        Point result = io_result;
        if (result == null) {
            result = new Point();
        }
        Vector3f vector = Draw3DCache.getVector3f();
        try {
            this.validateWorldToSurface();
            vector.set(i_world);
            vector.transform((IMatrix4f)this.m_worldToSurface);
            result.x = (int)vector.getX();
            result.y = (int)vector.getY();
            point = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{vector});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{vector});
        return point;
    }

    public Vector3f getSurfaceLocation3D(float i_wx, float i_wy, float i_wz, Vector3f io_result) {
        Vector3f vector3f;
        Vector3f w = Draw3DCache.getVector3f();
        try {
            w.set(i_wx, i_wy, i_wz);
            vector3f = this.getSurfaceLocation3D((IVector3f)w, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
        return vector3f;
    }

    public Vector3f getSurfaceLocation3D(ISurface i_reference, Vector3f i_surface, Vector3f io_result) {
        Vector3f vector3f;
        Vector3f w = Draw3DCache.getVector3f();
        try {
            i_reference.getWorldLocation((IVector3f)i_surface, w);
            vector3f = this.getSurfaceLocation3D((IVector3f)w, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
        return vector3f;
    }

    public Vector3f getSurfaceLocation3D(IVector3f i_rayOrigin, IVector3f i_rayDirection, Vector3f io_result) {
        Vector3f w;
        Vector3f n;
        Vector3f p;
        block3: {
            p = Draw3DCache.getVector3f();
            n = Draw3DCache.getVector3f();
            w = Draw3DCache.getVector3f();
            try {
                this.getOrigin(p);
                this.getZAxis(n);
                Math3D.rayIntersectsPlane((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (IVector3f)p, (IVector3f)n, (Vector3f)w);
                if (w != null) break block3;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{p, n, w});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{p, n, w});
            return null;
        }
        Vector3f vector3f = this.getSurfaceLocation3D((IVector3f)w, io_result);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{p, n, w});
        return vector3f;
    }

    public Vector3f getSurfaceLocation3D(IVector3f i_world, Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (this.m_cachedProjection != null && i_world.equals((IVector3f)this.m_cachedProjection[0])) {
            result.set((IVector3f)this.m_cachedProjection[1]);
            return result;
        }
        this.validateWorldToSurface();
        result.set(i_world);
        result.transform((IMatrix4f)this.m_worldToSurface);
        this.setCachedProjection(i_world, (IVector3f)result);
        return result;
    }

    public Vector3f getWorldDimension(Dimension i_surface, Vector3f o_result) {
        Vector3f vector3f;
        Vector3f start = Draw3DCache.getVector3f();
        Vector3f end = Draw3DCache.getVector3f();
        try {
            this.getWorldLocation(0.0f, 0.0f, 0.0f, start);
            this.getWorldLocation(i_surface.width, i_surface.height, 0.0f, end);
            vector3f = Math3D.sub((IVector3f)end, (IVector3f)start, (Vector3f)o_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{start});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{start});
        return vector3f;
    }

    public Vector3f getWorldLocation(float i_sx, float i_sy, float i_sz, Vector3f io_result) {
        Vector3f vector3f;
        Vector3f s = Draw3DCache.getVector3f();
        try {
            s.set(i_sx, i_sy, i_sz);
            vector3f = this.getWorldLocation((IVector3f)s, io_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{s});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{s});
        return vector3f;
    }

    public Vector3f getWorldLocation(IVector3f i_surface, Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (this.m_cachedProjection != null && i_surface.equals((IVector3f)this.m_cachedProjection[1])) {
            result.set((IVector3f)this.m_cachedProjection[0]);
            return result;
        }
        result.set(i_surface);
        this.validateSurfaceToWorld();
        result.transform((IMatrix4f)this.m_surfaceToWorld);
        this.setCachedProjection((IVector3f)result, i_surface);
        return result;
    }

    public Vector3f getWorldLocation(Point i_surface, Vector3f io_result) {
        return this.getWorldLocation(i_surface.x, i_surface.y, 0.0f, io_result);
    }

    protected abstract Vector3f getXAxis(Vector3f var1);

    protected abstract Vector3f getYAxis(Vector3f var1);

    protected abstract Vector3f getZAxis(Vector3f var1);

    private void setCachedProjection(IVector3f i_world, IVector3f i_surface) {
        if (this.m_cachedProjection == null) {
            this.m_cachedProjection = new Vector3f[]{new Vector3fImpl(i_world), new Vector3fImpl(i_surface)};
        } else {
            this.m_cachedProjection[0].set(i_world);
            this.m_cachedProjection[1].set(i_surface);
        }
    }

    private void validateSurfaceToWorld() {
        if (this.m_surfaceToWorldValid) {
            return;
        }
        Vector3f origin = Draw3DCache.getVector3f();
        Vector3f xAxis = Draw3DCache.getVector3f();
        Vector3f yAxis = Draw3DCache.getVector3f();
        Vector3f zAxis = Draw3DCache.getVector3f();
        try {
            this.getXAxis(xAxis);
            this.getYAxis(yAxis);
            this.getZAxis(zAxis);
            this.getOrigin(origin);
            this.m_surfaceToWorld.set(0, 0, xAxis.getX());
            this.m_surfaceToWorld.set(0, 1, xAxis.getY());
            this.m_surfaceToWorld.set(0, 2, xAxis.getZ());
            this.m_surfaceToWorld.set(0, 3, 0.0f);
            this.m_surfaceToWorld.set(1, 0, yAxis.getX());
            this.m_surfaceToWorld.set(1, 1, yAxis.getY());
            this.m_surfaceToWorld.set(1, 2, yAxis.getZ());
            this.m_surfaceToWorld.set(1, 3, 0.0f);
            this.m_surfaceToWorld.set(2, 0, zAxis.getX());
            this.m_surfaceToWorld.set(2, 1, zAxis.getY());
            this.m_surfaceToWorld.set(2, 2, zAxis.getZ());
            this.m_surfaceToWorld.set(2, 3, 0.0f);
            this.m_surfaceToWorld.set(3, 0, origin.getX());
            this.m_surfaceToWorld.set(3, 1, origin.getY());
            this.m_surfaceToWorld.set(3, 2, origin.getZ());
            this.m_surfaceToWorld.set(3, 3, 1.0f);
            this.m_surfaceToWorldValid = true;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin, xAxis, yAxis, zAxis});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin, xAxis, yAxis, zAxis});
    }

    private void validateWorldToSurface() {
        if (this.m_worldToSurfaceValid) {
            return;
        }
        this.validateSurfaceToWorld();
        Math3D.invert((IMatrix4f)this.m_surfaceToWorld, (Matrix4f)this.m_worldToSurface);
        this.m_worldToSurfaceValid = true;
    }
}

