/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SShapeType implements Enumerator
{
    POINT(1, "Point", "POINT"),
    LINE(2, "Line", "LINE"),
    POLYGON(3, "Polygon", "POLYGON");

    public static final int POINT_VALUE = 1;
    public static final int LINE_VALUE = 2;
    public static final int POLYGON_VALUE = 3;
    private static final SShapeType[] VALUES_ARRAY;
    public static final List<SShapeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SShapeType[]{POINT, LINE, POLYGON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SShapeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SShapeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SShapeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SShapeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SShapeType get(int value) {
        switch (value) {
            case 1: {
                return POINT;
            }
            case 2: {
                return LINE;
            }
            case 3: {
                return POLYGON;
            }
        }
        return null;
    }

    private SShapeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

