/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.io.Serializable;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;

public class Vector3fImpl
implements Vector3f,
Cloneable,
Serializable {
    public float x;
    public float y;
    public float z;
    private static final long serialVersionUID = 1L;
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");

    static Vector3fImpl cast(IVector3f i_sourceVector3f) {
        if (i_sourceVector3f instanceof Vector3fImpl) {
            return (Vector3fImpl)i_sourceVector3f;
        }
        return new Vector3fImpl(i_sourceVector3f);
    }

    public Vector3fImpl() {
    }

    public Vector3fImpl(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3fImpl(IVector3f i_sourceVector3f) {
        this(i_sourceVector3f.getX(), i_sourceVector3f.getY(), i_sourceVector3f.getZ());
    }

    public Vector3fImpl(Vector3fImpl i_sourceVector3f) {
        this(i_sourceVector3f.x, i_sourceVector3f.y, i_sourceVector3f.z);
    }

    public Vector3fImpl(FloatBuffer i_floatBuffer) {
        this(i_floatBuffer.get(), i_floatBuffer.get(), i_floatBuffer.get());
    }

    public Vector3fImpl(float[] i_arrayOfFloat) {
        this(i_arrayOfFloat[0], i_arrayOfFloat[1], i_arrayOfFloat[2]);
    }

    public Vector3fImpl(float[] i_arrayOfFloat, int i_iOffset) {
        this(i_arrayOfFloat[i_iOffset++], i_arrayOfFloat[i_iOffset++], i_arrayOfFloat[i_iOffset]);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Vector3fImpl(this);
    }

    public void set(IVector3f i_vector3f) {
        this.x = i_vector3f.getX();
        this.y = i_vector3f.getY();
        this.z = i_vector3f.getZ();
    }

    public void set(float i_x, float i_y, float i_z) {
        this.x = i_x;
        this.y = i_y;
        this.z = i_z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public boolean equals(IVector3f v) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return this.x == v.getX() && this.y == v.getY() && this.z == v.getZ();
    }

    public boolean equals(Object i_obj) {
        if (i_obj instanceof IVector3f) {
            return this.equals((IVector3f)i_obj);
        }
        return false;
    }

    public boolean equals(IVector3f v, float epsilon) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return Math.abs(this.x - v.getX()) <= epsilon && Math.abs(this.y - v.getY()) <= epsilon && Math.abs(this.z - v.getZ()) <= epsilon;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void toArray(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.x;
        o_arrayOfFloat[1] = this.y;
        o_arrayOfFloat[2] = this.z;
    }

    public void toArray(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.x;
        o_arrayOfFloat[i_iOffset++] = this.y;
        o_arrayOfFloat[i_iOffset] = this.z;
    }

    public void toBuffer(FloatBuffer o_floatBuffer) {
        o_floatBuffer.put(this.x);
        o_floatBuffer.put(this.y);
        o_floatBuffer.put(this.z);
    }

    public String toString() {
        return String.format("(%s, %s, %s)", DECIMAL_FORMAT.format(this.x), DECIMAL_FORMAT.format(this.y), DECIMAL_FORMAT.format(this.z));
    }

    public int hashCode() {
        float[] af = new float[3];
        this.toArray(af);
        return Arrays.hashCode(af);
    }

    public void scale(float i_factor) {
        Math3D.scale(i_factor, (IVector3f)this, (Vector3f)this);
    }

    public void transform(IMatrix4f i_matrix4f) {
        Math3D.transform((IVector3f)this, i_matrix4f, (Vector3f)this);
    }

    public void translate(float i_dx, float i_dy, float i_dz) {
        Math3D.translate(this, i_dx, i_dy, i_dz, this);
    }
}

