/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.Math3DMatrix2f;
import org.eclipse.draw3d.geometry.Matrix3f;
import org.eclipse.draw3d.geometry.Matrix3fImpl;

public class Math3DMatrix3f
extends Math3DMatrix2f {
    public static Matrix3f add(IMatrix3f i_left, IMatrix3f i_right, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl left = Matrix3fImpl.cast(i_left);
        Matrix3fImpl right = Matrix3fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix3fImpl();
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = left.a11 + right.a11;
        result.a12 = left.a12 + right.a12;
        result.a13 = left.a13 + right.a13;
        result.a21 = left.a21 + right.a21;
        result.a22 = left.a22 + right.a22;
        result.a23 = left.a23 + right.a23;
        result.a31 = left.a31 + right.a31;
        result.a32 = left.a32 + right.a32;
        result.a33 = left.a33 + right.a33;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f sub(IMatrix3f i_left, IMatrix3f i_right, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl left = Matrix3fImpl.cast(i_left);
        Matrix3fImpl right = Matrix3fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix3fImpl();
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = left.a11 - right.a11;
        result.a12 = left.a12 - right.a12;
        result.a13 = left.a13 - right.a13;
        result.a21 = left.a21 - right.a21;
        result.a22 = left.a22 - right.a22;
        result.a23 = left.a23 - right.a23;
        result.a31 = left.a31 - right.a31;
        result.a32 = left.a32 - right.a32;
        result.a33 = left.a33 - right.a33;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f mul(IMatrix3f i_left, IMatrix3f i_right, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl left = Matrix3fImpl.cast(i_left);
        Matrix3fImpl right = Matrix3fImpl.cast(i_right);
        if (o_result == null || o_result == left || o_result == right) {
            result = new Matrix3fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = left.a11 * right.a11 + left.a21 * right.a12 + left.a31 * right.a13;
        result.a12 = left.a12 * right.a11 + left.a22 * right.a12 + left.a32 * right.a13;
        result.a13 = left.a13 * right.a11 + left.a23 * right.a12 + left.a33 * right.a13;
        result.a21 = left.a11 * right.a21 + left.a21 * right.a22 + left.a31 * right.a23;
        result.a22 = left.a12 * right.a21 + left.a22 * right.a22 + left.a32 * right.a23;
        result.a23 = left.a13 * right.a21 + left.a23 * right.a22 + left.a33 * right.a23;
        result.a31 = left.a11 * right.a31 + left.a21 * right.a32 + left.a31 * right.a33;
        result.a32 = left.a12 * right.a31 + left.a22 * right.a32 + left.a32 * right.a33;
        result.a33 = left.a13 * right.a31 + left.a23 * right.a32 + left.a33 * right.a33;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f transpose(IMatrix3f i_source, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix3fImpl();
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        if (result == m) {
            float t = result.a12;
            result.a12 = m.a21;
            result.a21 = t;
            t = result.a13;
            result.a13 = m.a31;
            result.a31 = t;
            t = result.a23;
            result.a23 = m.a32;
            result.a32 = t;
        } else {
            result.a11 = m.a11;
            result.a22 = m.a22;
            result.a33 = m.a33;
            result.a12 = m.a21;
            result.a21 = m.a12;
            result.a13 = m.a31;
            result.a31 = m.a13;
            result.a23 = m.a32;
            result.a32 = m.a23;
        }
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static float determinant(IMatrix3f i_matrix) {
        Matrix3fImpl m = Matrix3fImpl.cast(i_matrix);
        return Math3DMatrix3f.det(m.a11, m.a12, m.a13, m.a21, m.a22, m.a23, m.a31, m.a32, m.a33);
    }

    public static Matrix3f invert(IMatrix3f i_source, Matrix3f o_result) {
        float det = Math3DMatrix3f.determinant(i_source);
        if (det != 0.0f) {
            o_result = Math3DMatrix3f.adjugate(i_source, o_result);
            return Math3DMatrix3f.mul(1.0f / det, (IMatrix3f)o_result, o_result);
        }
        return null;
    }

    public static Matrix3f adjugate(IMatrix3f i_source, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        if (o_result == null || o_result == m) {
            result = new Matrix3fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = Math3DMatrix3f.det(m.a22, m.a23, m.a32, m.a33);
        result.a12 = Math3DMatrix3f.negdet(m.a12, m.a13, m.a32, m.a33);
        result.a13 = Math3DMatrix3f.det(m.a12, m.a13, m.a22, m.a23);
        result.a21 = Math3DMatrix3f.negdet(m.a21, m.a23, m.a31, m.a33);
        result.a22 = Math3DMatrix3f.det(m.a11, m.a13, m.a31, m.a33);
        result.a23 = Math3DMatrix3f.negdet(m.a11, m.a13, m.a21, m.a23);
        result.a31 = Math3DMatrix3f.det(m.a21, m.a22, m.a31, m.a32);
        result.a32 = Math3DMatrix3f.negdet(m.a11, m.a12, m.a31, m.a32);
        result.a33 = Math3DMatrix3f.det(m.a11, m.a12, m.a21, m.a22);
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f mul(float f, IMatrix3f i_source, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix3fImpl(m);
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
            result.set(m);
        }
        result.a11 *= f;
        result.a12 *= f;
        result.a13 *= f;
        result.a21 *= f;
        result.a22 *= f;
        result.a23 *= f;
        result.a31 *= f;
        result.a32 *= f;
        result.a33 *= f;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f negate(IMatrix3f i_source, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        if (o_result == null || o_result == m) {
            result = new Matrix3fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = -m.a11;
        result.a12 = -m.a12;
        result.a13 = -m.a13;
        result.a21 = -m.a21;
        result.a22 = -m.a22;
        result.a23 = -m.a23;
        result.a31 = -m.a31;
        result.a32 = -m.a32;
        result.a33 = -m.a33;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static float det(float a, float b, float c, float d, float e, float f, float g, float h, float i) {
        return a * Math3DMatrix3f.det(e, f, h, i) - b * Math3DMatrix3f.det(d, f, g, i) + c * Math3DMatrix3f.det(d, e, g, h);
    }

    public static float negdet(float a, float b, float c, float d, float e, float f, float g, float h, float i) {
        return b * Math3DMatrix3f.det(d, f, g, i) - c * Math3DMatrix3f.det(d, e, g, h) - a * Math3DMatrix3f.det(e, f, h, i);
    }
}

