/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.metaabm.IID;
import org.metaabm.SNamed;
import org.metaabm.act.AInput;
import org.metaabm.provider.MetaABMItemProviderAdapterFactory;

public abstract class MetaABMItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
ITableItemLabelProvider {
    protected static boolean displayAttributeReferences;

    public MetaABMItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String suggestLabel(IID object) {
        return this.getString("_UI_" + object.eClass().getName() + "_type");
    }

    public String suggestID(IID object) {
        return StringUtils.uncapitalize((String)StringUtils.deleteWhitespace((String)StringUtils.capitalize((String)this.getString("_UI_" + object.eClass().getName() + "_type"))));
    }

    public boolean isDisplayAttributeReferences() {
        return displayAttributeReferences;
    }

    public void setDisplayAttributeReferences(boolean _displayAttributeReferences) {
        displayAttributeReferences = _displayAttributeReferences;
    }

    public static Collection<?> labels(Collection<?> ids) {
        Collection inputLabels = CollectionUtils.collect(ids, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((IID)o).getLabel();
            }
        });
        return inputLabels;
    }

    public static Collection<?> texts(Collection<?> ids) {
        Collection inputLabels = CollectionUtils.collect(ids, (Transformer)new Transformer(){

            public Object transform(Object o) {
                MetaABMItemProvider provider = MetaABMItemProvider.providerFor(o);
                if (provider != null) {
                    return provider.getText(o);
                }
                return "--";
            }
        });
        return inputLabels;
    }

    public static MetaABMItemProvider providerFor(Object o) {
        MetaABMItemProvider provider = (MetaABMItemProvider)((Object)MetaABMItemProviderAdapterFactory.getGenericAdapterFactory().adapt(o, IEditingDomainItemProvider.class));
        return provider;
    }

    public static Collection<?> inputVals(Collection<AInput> inputs) {
        Collection inputLabels = CollectionUtils.collect(inputs, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((AInput)o).getValue();
            }
        });
        return inputLabels;
    }

    public static Collection<?> ids(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((IID)o).getID();
            }
        });
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection<?> selection) {
        ArrayList<Object> images = new ArrayList<Object>();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory().adapt(child, IItemLabelProvider.class);
        images.add(itemLabelProvider.getImage(child));
        images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/CreateChild"));
        return new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                List result = super.getDrawPoints(size);
                ((ComposedImage.Point)result.get((int)1)).x = size.width - 7;
                return result;
            }
        };
    }

    public String getColumnText(Object object, int columnIndex) {
        if (columnIndex == 0) {
            if (object instanceof IID) {
                return ((IID)object).getLabel();
            }
            return this.getText(object);
        }
        if (columnIndex == 1) {
            if (object instanceof SNamed) {
                return ((IID)object).getLabel();
            }
            return "";
        }
        return super.getColumnText(object, columnIndex);
    }

    public Object getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(object);
        }
        return null;
    }

    public static final Collection<?> idsCaps(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new Transformer(){

            public Object transform(Object o) {
                if (o instanceof IID) {
                    return StringUtils.capitalize((String)((IID)o).getID());
                }
                if (o instanceof AInput && ((AInput)o).getValue() != null) {
                    return StringUtils.capitalize((String)((AInput)o).getValue().getID());
                }
                return "null";
            }
        });
    }
}

