/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.sweep;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.ascape.util.sweep.SweepLink;
import org.ascape.util.sweep.Sweepable;

public class SweepGroup
implements Sweepable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Vector sweeps = new Vector();
    private int depth;
    private boolean hasNext;
    private int runsPer = 1;
    private int runCount;

    public void addMember(Sweepable sweep) {
        this.sweeps.addElement(sweep);
        if (!this.hasNext && sweep.hasNext()) {
            this.hasNext = true;
        }
        this.depth = 0;
    }

    public Sweepable getMember(int pos) {
        return (Sweepable)this.sweeps.elementAt(pos);
    }

    public Sweepable getUnlinkedMember(int pos) {
        int current = -1;
        Enumeration e = this.sweeps.elements();
        while (e.hasMoreElements()) {
            Sweepable sweep = (Sweepable)e.nextElement();
            if (!(sweep instanceof SweepLink)) {
                if (++current != pos) continue;
                return sweep;
            }
            Enumeration eLink = ((SweepLink)sweep).elements();
            while (eLink.hasMoreElements()) {
                Sweepable linkElement = (Sweepable)eLink.nextElement();
                if (++current != pos) continue;
                return linkElement;
            }
        }
        return null;
    }

    @Override
    public void reset() {
        Enumeration e = this.sweeps.elements();
        while (e.hasMoreElements()) {
            Sweepable sweep = (Sweepable)e.nextElement();
            sweep.reset();
            if (this.hasNext || !sweep.hasNext()) continue;
            this.hasNext = true;
        }
        this.depth = 0;
    }

    public int getRunsPer() {
        return this.runsPer;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void setRunsPer(int runsPer) {
        this.runsPer = runsPer;
    }

    @Override
    public boolean hasNext() {
        if (this.sweeps.size() == 0) {
            return false;
        }
        if (this.runCount < this.runsPer) {
            return true;
        }
        Enumeration e = this.sweeps.elements();
        while (e.hasMoreElements()) {
            if (!((Sweepable)e.nextElement()).hasNext()) continue;
            return true;
        }
        return false;
    }

    private Object nextInternal() {
        Sweepable currentSweep = (Sweepable)this.sweeps.elementAt(this.depth);
        if (currentSweep.hasNext()) {
            if (this.depth < this.sweeps.size() - 1) {
                ++this.depth;
                this.nextInternal();
            }
            return currentSweep.next();
        }
        currentSweep.reset();
        --this.depth;
        return this.nextInternal();
    }

    @Override
    public Object next() {
        if (this.runCount == this.runsPer) {
            this.runCount = 0;
        }
        ++this.runCount;
        if (this.runCount == 1) {
            return this.nextInternal();
        }
        return "-";
    }

    public int getUnlinkedSize() {
        int size = 0;
        Enumeration e = this.sweeps.elements();
        while (e.hasMoreElements()) {
            Sweepable sweep = (Sweepable)e.nextElement();
            if (!(sweep instanceof SweepLink)) {
                ++size;
                continue;
            }
            size += ((SweepLink)sweep).getSize();
        }
        return size;
    }

    public int getSize() {
        return this.sweeps.size();
    }
}

