/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DDiscrete;

public class Coordinate2DDiscrete
extends Coordinate1DDiscrete {
    private static final long serialVersionUID = 1L;

    public Coordinate2DDiscrete(int[] values) {
        super(values);
    }

    public Coordinate2DDiscrete(int x, int y) {
        this.values = new int[2];
        this.values[0] = x;
        this.values[1] = y;
    }

    public final int getYValue() {
        return this.values[1];
    }

    public final void setYValue(int y) {
        this.values[1] = y;
    }

    @Override
    public double getDistance(Coordinate target) {
        int minXDistance = Math.abs(this.values[0] - ((Coordinate2DDiscrete)target).getXValue());
        int minYDistance = Math.abs(this.values[1] - ((Coordinate2DDiscrete)target).getYValue());
        return Math.sqrt(minXDistance * minXDistance + minYDistance * minYDistance);
    }

    @Override
    public Coordinate add(Coordinate coordinate) {
        return new Coordinate2DDiscrete(this.getXValue() + ((Coordinate2DDiscrete)coordinate).getXValue(), this.getYValue() + ((Coordinate2DDiscrete)coordinate).getYValue());
    }

    @Override
    public String toString() {
        return "[" + this.getXValue() + ", " + this.getYValue() + "]";
    }
}

