/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.engine;

import org.ascape.model.engine.IncrementalExecutionStrategy;
import org.ascape.model.engine.ParallelManager;
import org.ascape.model.engine.StrategyFactory;

public abstract class ParallelExecutionStrategy
extends IncrementalExecutionStrategy {
    private static final long serialVersionUID = 1L;
    private ParallelManager parallelManager;
    int x;

    public ParallelExecutionStrategy(StrategyFactory factory) {
        super(factory);
    }

    @Override
    public void execute() {
        if (this.isSupportsParallel() && this.factory.getThreads() > 1 && this.factory.getScape().size() > 10) {
            if (this.parallelManager == null) {
                this.parallelManager = new ParallelManager(this.factory, this);
            } else {
                this.parallelManager.setFactory(this.factory);
                this.parallelManager.setMainStrategy(this);
            }
            this.parallelManager.execute();
            this.reset();
        } else {
            super.execute();
        }
    }

    public final void executeParallel() {
        while (this.hasNextParallel()) {
            this.increment();
            this.fire();
        }
    }

    public boolean hasNextParallel() {
        throw new UnsupportedOperationException("Parallel operation not supported for this strategy.");
    }

    public void incrementParallel() {
        this.increment();
    }

    public void nextParallelSequence() {
        throw new UnsupportedOperationException("Parallel operation not supported for this strategy.");
    }
}

