/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera.tracking;

import java.util.List;
import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.tracking.ICameraMove;

public abstract class MoveSeries
implements ICameraMove {
    List<Float> weights;
    List<ICameraMove> moves;
    List<Float> startTicks;
    List<Float> relativeDurations;

    public void addCameraMove(ICameraMove move, float weight) {
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("Weight must be greater than 0");
        }
        this.weights.add(Float.valueOf(weight));
        this.moves.add(move);
        this.updateStartTicks();
    }

    protected void updateStartTicks() {
        this.startTicks.clear();
        this.relativeDurations.clear();
        float totalWeight = 0.0f;
        for (float weight : this.weights) {
            totalWeight += weight;
        }
        float passedDuration = 0.0f;
        int i = 0;
        while (i < this.weights.size()) {
            this.startTicks.add(Float.valueOf(passedDuration));
            float relativeDuration = this.weights.get(i).floatValue() / totalWeight;
            passedDuration += relativeDuration;
            this.relativeDurations.add(Float.valueOf(relativeDuration));
            ++i;
        }
    }

    public void updateCameraPosition(CameraPosition io_cameraPosition, float prevTick, float currentTick) {
        float relativePrevTick;
        int currentMoveNumber = this.findMove(currentTick);
        int prevMoveNumber = this.findMove(prevTick);
        if (prevMoveNumber >= 0 && currentMoveNumber != prevMoveNumber && (relativePrevTick = this.makeTickRelative(prevTick, prevMoveNumber)) != 1.0f) {
            this.moves.get(prevMoveNumber).updateCameraPosition(io_cameraPosition, relativePrevTick, 1.0f);
        }
        relativePrevTick = this.makeTickRelative(prevTick, currentMoveNumber);
        float relativeCurrentTick = this.makeTickRelative(currentTick, currentMoveNumber);
        this.moves.get(currentMoveNumber).updateCameraPosition(io_cameraPosition, relativePrevTick, relativeCurrentTick);
    }

    protected float makeTickRelative(float i_Tick, int i_MoveNumber) {
        if (i_Tick == 1.0f) {
            return 1.0f;
        }
        float relativeDuration = this.relativeDurations.get(i_MoveNumber).floatValue();
        float tick = (i_Tick - this.startTicks.get(i_MoveNumber).floatValue()) / relativeDuration;
        if (tick < 0.0f) {
            return -1.0f;
        }
        if (tick > 1.0f) {
            tick = 1.0f;
        }
        return tick;
    }

    protected int findMove(float i_tick) {
        if (i_tick < 0.0f) {
            return -1;
        }
        if (i_tick > 1.0f) {
            return this.moves.size() - 1;
        }
        int i = this.moves.size() - 1;
        while (i > 0) {
            if (this.startTicks.get(i).floatValue() <= i_tick) {
                return i;
            }
            --i;
        }
        return 0;
    }
}

